/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyoto_u.jfftw3;

import java.util.Set;
import jp.ac.kyoto_u.jfftw3.Flag;
import jp.ac.kyoto_u.jfftw3.Misc;
import jp.ac.kyoto_u.jfftw3.NonPositiveTransformSizeException;
import jp.ac.kyoto_u.jfftw3.Plan;
import jp.ac.kyoto_u.jfftw3.R2rKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlanR2r
extends Plan {
    private PlanR2r(int n) {
        super(n, n);
    }

    public static final PlanR2r newPlan(int n, R2rKind r2rKind, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n");
        }
        if (r2rKind == null) {
            throw new NullPointerException("kind");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n2 = n;
        PlanR2r planR2r = new PlanR2r(n2);
        planR2r.fftwPlanR2r1d(n, r2rKind, set);
        return planR2r;
    }

    public static final PlanR2r newPlan(int n, int n2, R2rKind r2rKind, R2rKind r2rKind2, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n0");
        }
        if (n2 <= 0) {
            throw new NonPositiveTransformSizeException(n2, "n1");
        }
        if (r2rKind == null) {
            throw new NullPointerException("kind0");
        }
        if (r2rKind2 == null) {
            throw new NullPointerException("kind1");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n3 = n * n2;
        PlanR2r planR2r = new PlanR2r(n3);
        planR2r.fftwPlanR2r2d(n, n2, r2rKind, r2rKind2, set);
        return planR2r;
    }

    public static final PlanR2r newPlan(int n, int n2, int n3, R2rKind r2rKind, R2rKind r2rKind2, R2rKind r2rKind3, Set<Flag> set) {
        if (n <= 0) {
            throw new NonPositiveTransformSizeException(n, "n0");
        }
        if (n2 <= 0) {
            throw new NonPositiveTransformSizeException(n2, "n1");
        }
        if (n3 <= 0) {
            throw new NonPositiveTransformSizeException(n3, "n2");
        }
        if (r2rKind == null) {
            throw new NullPointerException("kind0");
        }
        if (r2rKind2 == null) {
            throw new NullPointerException("kind1");
        }
        if (r2rKind3 == null) {
            throw new NullPointerException("kind2");
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        int n4 = n * n2 * n3;
        PlanR2r planR2r = new PlanR2r(n4);
        planR2r.fftwPlanR2r3d(n, n2, n3, r2rKind, r2rKind2, r2rKind3, set);
        return planR2r;
    }

    public static final PlanR2r newPlan(int n, int[] nArray, R2rKind[] r2rKindArray, Set<Flag> set) {
        int n2;
        if (nArray == null) {
            throw new NullPointerException("n");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("n.length must be positive");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] > 0) continue;
            throw new NonPositiveTransformSizeException(nArray[n2], String.format("n[%d]", n2));
        }
        if (r2rKindArray == null) {
            throw new NullPointerException("kind");
        }
        if (r2rKindArray.length != nArray.length) {
            throw new IllegalArgumentException(String.format("n.length and kind.length do not match: n.length = %d, kind.length = %d", nArray.length, r2rKindArray.length));
        }
        if (set == null) {
            throw new NullPointerException("flagSet");
        }
        n2 = Misc.prod(nArray);
        PlanR2r planR2r = new PlanR2r(n2);
        planR2r.fftwPlanR2r(nArray, r2rKindArray, set);
        return planR2r;
    }

    private final native void fftwPlanR2r1d(int var1, R2rKind var2, Set<Flag> var3);

    private final native void fftwPlanR2r2d(int var1, int var2, R2rKind var3, R2rKind var4, Set<Flag> var5);

    private final native void fftwPlanR2r3d(int var1, int var2, int var3, R2rKind var4, R2rKind var5, R2rKind var6, Set<Flag> var7);

    private final native void fftwPlanR2r(int[] var1, R2rKind[] var2, Set<Flag> var3);

    static {
        System.loadLibrary("jfftw3");
    }
}

