#include <jni.h>
#include <fftw3.h>
#include "../../include/jp_ac_kyoto_0005fu_jfftw3_PlanC2c.h"
#include "Plan.h"
#include "Flag.h"
#include "Sign.h"

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanC2c
 * Method:    fftwPlanDft1d
 * Signature: (ILjp/ac/kyoto_u/jfftw3/Sign;Ljava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanC2c_fftwPlanDft1d
(JNIEnv *const env,
 jobject const obj,
 jint const n,
 jobject const sign,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  fftw_complex *const in = (fftw_complex*)getInArray(clazz, obj, env);
  fftw_complex *const out = (fftw_complex*)getOutArray(clazz, obj, env);
  int const s = getSign(sign, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_dft_1d(n, in, out, s, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanC2c
 * Method:    fftwPlanDft2d
 * Signature: (IILjp/ac/kyoto_u/jfftw3/Sign;Ljava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanC2c_fftwPlanDft2d
(JNIEnv *const env,
 jobject const obj,
 jint const n0,
 jint const n1,
 jobject const sign,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  fftw_complex *const in = (fftw_complex*)getInArray(clazz, obj, env);
  fftw_complex *const out = (fftw_complex*)getOutArray(clazz, obj, env);
  int const s = getSign(sign, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_dft_2d(n0, n1, in, out, s, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanC2c
 * Method:    fftwPlanDft3d
 * Signature: (IIILjp/ac/kyoto_u/jfftw3/Sign;Ljava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanC2c_fftwPlanDft3d
(JNIEnv *const env,
 jobject const obj,
 jint const n0,
 jint const n1,
 jint const n2,
 jobject const sign,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  fftw_complex *const in = (fftw_complex*)getInArray(clazz, obj, env);
  fftw_complex *const out = (fftw_complex*)getOutArray(clazz, obj, env);
  int const s = getSign(sign, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan = 
    fftw_plan_dft_3d(n0, n1, n2, in, out, s, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
}

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_PlanC2c
 * Method:    fftwPlanDft
 * Signature: ([ILjp/ac/kyoto_u/jfftw3/Sign;Ljava/util/Set;)V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_PlanC2c_fftwPlanDft
(JNIEnv *const env,
 jobject const obj,
 jintArray const n,
 jobject const sign,
 jobject const flagSet) {
  jclass const clazz = (*env)->GetObjectClass(env, obj);
  int const rank = (*env)->GetArrayLength(env, n);
  int *const dim = (*env)->GetIntArrayElements(env, n, NULL);
  if (dim == NULL) {
    (*env)->FatalError(env, "GetIntArrayElements()");
    return;
  }
  fftw_complex *const in = (fftw_complex*)getInArray(clazz, obj, env);
  fftw_complex *const out = (fftw_complex*)getOutArray(clazz, obj, env);
  int const s = getSign(sign, env);
  unsigned const f = getFlags(flagSet, env);
  fftw_plan const plan =
    fftw_plan_dft(rank, dim, in, out, s, f);
  setPlan(clazz, obj, plan, env);
  (*env)->DeleteLocalRef(env, (jobject)clazz);
  (*env)->ReleaseIntArrayElements(env, n, dim, JNI_ABORT);
}
