#include <jni.h>
#include <fftw3.h>
#include "../../include/jp_ac_kyoto_0005fu_jfftw3_Sign.h"
#include "Sign.h"

const char *const SIGN_SIGNATURE = "Ljp/ac/kyoto_u/jfftw3/Sign;";

jobject getSignGlobalRef(jclass, const char *, JNIEnv *);

jobject forward;
jobject backward;

/*
 * Class:     jp_ac_kyoto_0005fu_jfftw3_Sign
 * Method:    init
 * Signature: ()V
 */
JNIEXPORT void JNICALL
Java_jp_ac_kyoto_1u_jfftw3_Sign_init
(JNIEnv *const env,
 jclass const clazz) {
  forward =
    getSignGlobalRef(clazz, "FORWARD", env);
  backward =
    getSignGlobalRef(clazz, "BACKWARD", env);
}

int
getSign
(jobject const sign,
 JNIEnv *const env) {
  if ((*env)->IsSameObject(env, sign, forward) == JNI_TRUE)
    return FFTW_FORWARD;
  if ((*env)->IsSameObject(env, sign, backward) == JNI_TRUE)
    return FFTW_BACKWARD;

  (*env)->FatalError(env, "illegal Sign instance");
  return (int)NULL;
}

jobject
getSignGlobalRef
(jclass const clazz,
 const char *const name,
 JNIEnv *const env) {
  jfieldID const field_id =
    (*env)->GetStaticFieldID(env, clazz, name, SIGN_SIGNATURE);
  if (field_id == NULL) {
    char str[100];
    sprintf(str, "GetStaticFieldID(jp.ac.kyoto_u.jfftw3.Sign.%s)", name);
    (*env)->FatalError(env, str);
    return NULL;
  }
  jobject const localref =
    (*env)->GetStaticObjectField(env, clazz, field_id);
  jobject const globalref =
    (*env)->NewGlobalRef(env, localref);
  if (globalref == NULL) {
    (*env)->FatalError(env, "NewGlobalRef()");
    return NULL;
  }
  (*env)->DeleteLocalRef(env, localref);
  return globalref;
}
