package jp.ac.kyoto_u.jfftw3;

/**
 * 不正な変換のサイズが指定されたことを示すためにスローされる例外です。
 * @author Katsutoshi Itoyama (itoyama[at]kuis.kyoto-u.ac.jp)
 * @version 2009.10.04
 */
public class NonPositiveTransformSizeException
  extends IllegalArgumentException {

  /**
   * 詳細メッセージを持たない{@code NonPositiveTransformSizeException}を構築します。
   */
  public NonPositiveTransformSizeException() {
    super();
  }

  /**
   * 指定された詳細メッセージを持つ{@code NonPositiveTransformSizeException}を構築します。
   * @param s 詳細メッセージ
   */
  public NonPositiveTransformSizeException(final String s) {
    super(s);
  }

  /**
   * 指定された値を元に構築された詳細メッセージ持つ{@code NonPositiveTransformSizeException}を構築します。このコンストラクタ呼び出しは、{@code new NonPositiveTransformSizeException(Integer.toString(n))}と等価です。
   * @param n メッセージを構築するための値
   */
  public NonPositiveTransformSizeException(final int n) {
    super(Integer.toString(n));
  }

  /**
   * 指定された値と名前を元に構築された詳細メッセージ持つ{@code NonPositiveTransformSizeException}を構築します。このコンストラクタ呼び出しは、{@code new NonPositiveTransformSizeException(String.format("%s must be positive: %d", name, n))}と等価です。
   * @param n メッセージを構築するための値
   * @param name 値の名前
   */
  public NonPositiveTransformSizeException(final int n, final String name) {
    super(String.format("%s must be positive: %d", name, n));
  }

  /** automatically-generated by IDE (Eclipse) */
  private static final long serialVersionUID = 434997777262270533L;
}
