package jp.ac.kyoto_u.jfftw3;

/**
 * 実変換の種類を定めた定数です。
 * @author Katsutoshi Itoyama (itoyama[at]kuis.kyoto-u.ac.jp)
 * @version 2009.10.04
 */
public enum R2rKind {
  /** 実数配列を入力としたDFTにおいて、halfcomplexフォーマットで出力を行う演算です。例えば、1次元のサイズ{@code n}の変換においては、{@code r[0], r[1], r[2], ..., r[n/2], i[(n+1)/2-1], ..., i[2], i[1]}というフォーマットの配列を出力します。 */
  R2HC,

  /** R2HCを指定した場合の逆の演算です。 */
  HC2R,

  /** 離散ハートレー変換です。 */
  DHT,

  /** DCT-Iです。 */
  REDFT00,

  /** DCT-IIです。一般的に離散コサイン変換と呼ばれる演算です。 */
  REDFT01,

  /** DCT-IIIです。一般的に逆離散コサイン変換と呼ばれる演算です。 */
  REDFT10,

  /** DCT-IVです。 */
  REDFT11,

  /** DST-Iです。 */
  RODFT00,

  /** DST-IIです。 */
  RODFT01,

  /** DST-IIIです。 */
  RODFT10,

  /** DST-IVです。 */
  RODFT11;

  static {
    System.loadLibrary("jfftw3");
    init();
  }

  private static final native void init();
}
