package jp.ac.kyoto_u.jfftw3;

/**
 * 離散フーリエ変換における変換の方向を定めた定数です。
 * （厳密にはフーリエ変換における指数関数部の符号を表します。）
 * @author Katsutoshi Itoyama (itoyama[at]kuis.kyoto-u.ac.jp)
 * @version 2009.10.04
 */
public enum Sign {

  /** 順方向のフーリエ変換を表します。 */
  FORWARD,

  /** 逆方向のフーリエ変換を表します。 */
  BACKWARD;

  static {
    System.loadLibrary("jfftw3");
    init();
  }

  private static final native void init();
}
