/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.DataTypes;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;

public class DataSet
implements Serializable {
    public String identifier = null;
    public DataSet[] sub_sets = null;
    public double start = Double.NaN;
    public double stop = Double.NaN;
    public double[][] feature_values = null;
    public String[] feature_names = null;
    public DataSet parent = null;
    private static final long serialVersionUID = 3L;

    public void orderAndCompactFeatures(FeatureDefinition[] featureDefinitionArray, boolean bl) throws Exception {
        int n;
        double[][] dArrayArray = new double[featureDefinitionArray.length][];
        if (this.feature_names == null || this.feature_values == null) {
            for (n = 0; n < dArrayArray.length; ++n) {
                dArrayArray[n] = null;
            }
        } else {
            for (n = 0; n < dArrayArray.length; ++n) {
                dArrayArray[n] = null;
                for (int i = 0; i < this.feature_names.length; ++i) {
                    if (!featureDefinitionArray[n].name.equals(this.feature_names[i])) continue;
                    if (!bl && !featureDefinitionArray[n].is_sequential) {
                        throw new Exception("Feature " + this.feature_names[i] + " is present in a sub-set of\n" + "a DataSet, but is marked as non-sequential in its definition.");
                    }
                    if (this.feature_values[i].length != featureDefinitionArray[n].dimensions) {
                        throw new Exception("Feature " + this.feature_names[i] + " has " + this.feature_values[i].length + " values, but should have " + featureDefinitionArray[n].dimensions + "\n" + "according to its definition.");
                    }
                    dArrayArray[n] = this.feature_values[i];
                    i = this.feature_values.length;
                }
            }
        }
        this.feature_names = null;
        this.feature_values = dArrayArray;
        if (this.sub_sets != null) {
            for (n = 0; n < this.sub_sets.length; ++n) {
                this.sub_sets[n].orderAndCompactFeatures(featureDefinitionArray, false);
            }
        }
    }

    public String[][] getFeatureValuesOfTopLevel(FeatureDefinition[] featureDefinitionArray) {
        if (this.feature_values == null) {
            return null;
        }
        String[][] stringArray = new String[this.feature_values.length][];
        for (int i = 0; i < this.feature_values.length; ++i) {
            int n;
            if (this.feature_values[i] == null) {
                stringArray[i] = new String[featureDefinitionArray[i].dimensions];
                for (n = 0; n < stringArray[i].length; ++n) {
                    stringArray[i][n] = "?";
                }
                continue;
            }
            stringArray[i] = new String[this.feature_values[i].length];
            for (n = 0; n < this.feature_values[i].length; ++n) {
                stringArray[i][n] = String.valueOf(this.feature_values[i][n]);
            }
        }
        return stringArray;
    }

    public String[][][] getFeatureValuesOfSubSections(FeatureDefinition[] featureDefinitionArray) {
        if (this.sub_sets == null) {
            return null;
        }
        String[][][] stringArray = new String[this.sub_sets.length][][];
        for (int i = 0; i < this.sub_sets.length; ++i) {
            stringArray[i] = this.sub_sets[i].getFeatureValuesOfTopLevel(featureDefinitionArray);
        }
        return stringArray;
    }

    public String getDataSetDescription(int n) {
        String string = new String("");
        for (int i = 0; i < n; ++i) {
            string = string + "   ";
        }
        String string2 = new String("");
        if (this.identifier != null) {
            string2 = string + "DATASET " + this.identifier + ": ";
            string2 = this.sub_sets != null ? string2 + this.sub_sets.length + " sub-sets " : string2 + "0 sub-sets ";
            string2 = this.feature_values != null ? string2 + this.feature_values.length + " features\n\n" : string2 + "0 features\n\n";
        } else {
            string2 = string + "SUB-SET -> Start: " + this.start + "   Stop: " + this.stop + "\n";
        }
        String string3 = new String("");
        if (this.feature_values != null) {
            for (int i = 0; i < this.feature_values.length; ++i) {
                String string4 = string + string;
                if (this.feature_names != null) {
                    string4 = string4 + this.feature_names[i] + ": ";
                }
                if (this.feature_values[i] == null) {
                    string4 = string4 + "?";
                } else {
                    for (int j = 0; j < this.feature_values[i].length; ++j) {
                        string4 = string4 + this.feature_values[i][j] + " ";
                    }
                }
                string4 = string4 + "\n";
                string3 = string3 + string4;
            }
            string3 = string3 + "\n";
        }
        String string5 = new String("");
        if (this.sub_sets != null) {
            for (int i = 0; i < this.sub_sets.length; ++i) {
                string5 = string5 + this.sub_sets[i].getDataSetDescription(n + 1);
            }
        }
        return string2 + string3 + string5;
    }

    public static String getDataSetDescriptions(DataSet[] dataSetArray) {
        String string = new String();
        for (int i = 0; i < dataSetArray.length; ++i) {
            string = string + dataSetArray[i].getDataSetDescription(0);
        }
        return string;
    }

    public static DataSet[] parseDataSetFile(String string) throws Exception {
        Object[] objectArray = (Object[])XMLDocumentParser.parseXMLDocument(string, "feature_vector_file");
        DataSet[] dataSetArray = new DataSet[objectArray.length];
        for (int i = 0; i < dataSetArray.length; ++i) {
            dataSetArray[i] = (DataSet)objectArray[i];
        }
        return dataSetArray;
    }

    public static DataSet[] parseDataSetFile(String string, FeatureDefinition[] featureDefinitionArray) throws Exception {
        int n;
        Object[] objectArray = (Object[])XMLDocumentParser.parseXMLDocument(string, "feature_vector_file");
        DataSet[] dataSetArray = new DataSet[objectArray.length];
        for (n = 0; n < dataSetArray.length; ++n) {
            dataSetArray[n] = (DataSet)objectArray[n];
        }
        for (n = 0; n < dataSetArray.length; ++n) {
            dataSetArray[n].orderAndCompactFeatures(featureDefinitionArray, true);
        }
        return dataSetArray;
    }

    public static DataSet[] parseDataSetFiles(String[] stringArray, FeatureDefinition[] featureDefinitionArray) throws Exception {
        int n;
        DataSet[][] dataSetArrayArray = new DataSet[stringArray.length][];
        int n2 = 0;
        for (int i = 0; i < dataSetArrayArray.length; ++i) {
            Object[] objectArray = (Object[])XMLDocumentParser.parseXMLDocument(stringArray[i], "feature_vector_file");
            DataSet[] dataSetArray = new DataSet[objectArray.length];
            for (n = 0; n < dataSetArray.length; ++n) {
                dataSetArray[n] = (DataSet)objectArray[n];
            }
            if (featureDefinitionArray != null) {
                for (n = 0; n < dataSetArray.length; ++n) {
                    dataSetArray[n].orderAndCompactFeatures(featureDefinitionArray, true);
                }
            }
            dataSetArrayArray[i] = dataSetArray;
            n2 += dataSetArray.length;
        }
        DataSet[] dataSetArray = new DataSet[n2];
        int n3 = 0;
        for (int i = 0; i < dataSetArrayArray.length; ++i) {
            for (n = 0; n < dataSetArrayArray[i].length; ++n) {
                dataSetArray[n3] = dataSetArrayArray[i][n];
                ++n3;
            }
        }
        return dataSetArray;
    }

    public static void saveDataSets(DataSet[] dataSetArray, FeatureDefinition[] featureDefinitionArray, File file, String string) throws Exception {
        if (featureDefinitionArray == null) {
            for (int i = 0; i < dataSetArray.length; ++i) {
                if (dataSetArray[i].feature_names != null) continue;
                throw new Exception("Could not save because no feature definitions\nwere provided and DataSet " + dataSetArray[i].identifier + "\n" + "does not hold the names of its features.");
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            String string2 = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_vector_file [\n   <!ELEMENT feature_vector_file (comments, data_set+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT data_set (data_set_id, section*, feature*)>\n   <!ELEMENT data_set_id (#PCDATA)>\n   <!ELEMENT section (feature+)>\n   <!ATTLIST section start CDATA \"\"\n                     stop CDATA \"\">\n   <!ELEMENT feature (name, v+)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT v (#PCDATA)>\n]>\n\n<feature_vector_file>\n\n   <comments>" + string + "</comments>\n\n");
            dataOutputStream.writeBytes(string2);
            for (int i = 0; i < dataSetArray.length; ++i) {
                Object object;
                int n;
                dataOutputStream.writeBytes("   <data_set>\n");
                dataOutputStream.writeBytes("      <data_set_id>" + dataSetArray[i].identifier + "</data_set_id>\n");
                if (dataSetArray[i].sub_sets != null) {
                    for (n = 0; n < dataSetArray[i].sub_sets.length; ++n) {
                        object = dataSetArray[i].sub_sets[n];
                        dataOutputStream.writeBytes("      <section start=\"" + ((DataSet)object).start + "\" stop=\"" + ((DataSet)object).stop + "\">\n");
                        for (int j = 0; j < ((DataSet)object).feature_values.length; ++j) {
                            double[] dArray = ((DataSet)object).feature_values[j];
                            if (dArray == null) continue;
                            dataOutputStream.writeBytes("         <feature>\n");
                            if (((DataSet)object).feature_names != null) {
                                dataOutputStream.writeBytes("            <name>" + ((DataSet)object).feature_names[j] + "</name>\n");
                            } else {
                                dataOutputStream.writeBytes("            <name>" + featureDefinitionArray[j].name + "</name>\n");
                            }
                            for (int k = 0; k < dArray.length; ++k) {
                                dataOutputStream.writeBytes("            <v>" + dArray[k] + "</v>\n");
                            }
                            dataOutputStream.writeBytes("         </feature>\n");
                        }
                        dataOutputStream.writeBytes("      </section>\n");
                    }
                }
                if (dataSetArray[i].feature_values != null) {
                    for (n = 0; n < dataSetArray[i].feature_values.length; ++n) {
                        object = dataSetArray[i].feature_values[n];
                        if (object == null) continue;
                        dataOutputStream.writeBytes("      <feature>\n");
                        if (dataSetArray[i].feature_names != null) {
                            dataOutputStream.writeBytes("         <name>" + dataSetArray[i].feature_names[n] + "</name>\n");
                        } else {
                            dataOutputStream.writeBytes("         <name>" + featureDefinitionArray[n].name + "</name>\n");
                        }
                        for (int j = 0; j < ((Object)object).length; ++j) {
                            dataOutputStream.writeBytes("         <val>" + (double)object[j] + "</val>\n");
                        }
                        dataOutputStream.writeBytes("      </feature>\n");
                    }
                }
                dataOutputStream.writeBytes("   </data_set>\n\n");
            }
            dataOutputStream.writeBytes("</feature_vector_file>");
            dataOutputStream.close();
        }
        catch (Exception exception) {
            throw new Exception("Unable to write file " + file.getName() + ".");
        }
    }
}

