/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.ACE.XMLParsers;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.ACE.XMLParsers.ParseFileHandler;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParseBatchJobHandler
extends ParseFileHandler {
    public static final int BATCH_FILE = 0;
    public static final int BATCH = 1;
    public static final int FILE_SET = 2;
    public static final int FILE = 3;
    public static final int SETTINGS = 4;
    public static final int WINDOW_SIZE = 5;
    public static final int WINDOW_OVERLAP = 6;
    public static final int SAMPLING_RATE = 7;
    public static final int NORMALISE = 8;
    public static final int PER_WINDOW_STATS = 9;
    public static final int OVERALL_STATS = 10;
    public static final int OUTPUT_TYPE = 11;
    public static final int FEATURE = 12;
    public static final int ACTIVE = 13;
    public static final int ATTRIBUTE = 14;
    public static final int DESTINATION = 15;
    public static final int NAME = 16;
    public static final int AGGREGATOR = 17;
    public static final int AGGREGATOR_NAME = 18;
    public static final int AGGREGATOR_FEATURE = 19;
    public static final int AGGREGATOR_PARAMETER = 20;
    LinkedList<File> fileSet = new LinkedList();
    LinkedList<Batch> batchSet = new LinkedList();
    HashMap<String, Boolean> activeFeatureSet = new HashMap();
    HashMap<String, String[]> featureAttributeSet = new HashMap();
    LinkedList<String> tmpAttributeSet = new LinkedList();
    LinkedList<String> aggregatorList = new LinkedList();
    LinkedList<String[]> aggregatorFeatures = new LinkedList();
    LinkedList<String> tmpAggregatorFeatures = new LinkedList();
    LinkedList<String[]> aggregatorParameters = new LinkedList();
    LinkedList<String> tmpAggregatorParameters = new LinkedList();
    String name;
    String featureName;
    int windowSize;
    double windowOverlap;
    double sampleRate;
    boolean saveWindows;
    boolean overall;
    boolean normalise;
    int outputType;
    String destinationFV;
    String destinationFK;
    int tagType = -1;
    String fileName = "";

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        switch (this.tagType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.fileName = this.fileName + string;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                try {
                    this.windowSize = Integer.parseInt(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException("windowSize data must be an integer");
                }
            }
            case 6: {
                try {
                    double d = Double.parseDouble(string);
                    if (Double.isNaN(d) || Double.isNaN(d) || d < 0.0 || d >= 1.0) {
                        throw new SAXException("windowOverlap must be at least zero and less than the window size");
                    }
                    this.windowOverlap = d;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException("windowOverlap must be a double");
                }
            }
            case 7: {
                try {
                    this.sampleRate = Double.parseDouble(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException("Sampling rate must be a double");
                }
            }
            case 8: {
                if (string.equals("true")) {
                    this.normalise = true;
                    break;
                }
                this.normalise = false;
                break;
            }
            case 9: {
                if (string.equals("true")) {
                    this.saveWindows = true;
                    break;
                }
                this.saveWindows = false;
                break;
            }
            case 10: {
                if (string.equals("true")) {
                    this.overall = true;
                    break;
                }
                this.overall = false;
                break;
            }
            case 11: {
                if (string.equals("ACE")) {
                    this.outputType = 0;
                    break;
                }
                this.outputType = 1;
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                if (string.equals("true")) {
                    this.activeFeatureSet.put(this.featureName, true);
                    break;
                }
                this.activeFeatureSet.put(this.featureName, false);
                break;
            }
            case 14: {
                this.tmpAttributeSet.add(string);
                break;
            }
            case 15: {
                if (this.destinationFK != null) {
                    this.destinationFV = string;
                    break;
                }
                this.destinationFK = string;
                break;
            }
            case 16: {
                this.featureName = string;
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                this.aggregatorList.add(string);
                break;
            }
            case 19: {
                this.tmpAggregatorFeatures.add(string);
                break;
            }
            case 20: {
                this.tmpAggregatorParameters.add(string);
                break;
            }
            default: {
                throw new SAXException("Unknwon tagType " + this.tagType + " in characters");
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.tagType) {
            case 0: {
                this.parsed_file_contents = this.batchSet.toArray(new Batch[0]);
                break;
            }
            case 1: {
                Batch batch = new Batch();
                try {
                    batch.setRecordings(this.fileSet.toArray(new File[0]));
                }
                catch (Exception exception) {
                    throw new SAXException(exception.getMessage());
                }
                batch.setSettings(this.windowSize, this.windowOverlap, this.sampleRate, this.normalise, this.saveWindows, this.overall, this.outputType);
                batch.setDestination(this.destinationFK, this.destinationFV);
                batch.setFeatures(this.activeFeatureSet, this.featureAttributeSet);
                batch.setName(this.name);
                batch.setAggregators(this.aggregatorList.toArray(new String[0]), (String[][])this.aggregatorFeatures.toArray((T[])new String[0][]), (String[][])this.aggregatorParameters.toArray((T[])new String[0][]));
                this.name = null;
                this.batchSet.add(batch);
                this.fileSet.clear();
                this.activeFeatureSet = new HashMap();
                this.featureAttributeSet = new HashMap();
                this.aggregatorList = new LinkedList();
                this.aggregatorFeatures = new LinkedList();
                this.aggregatorParameters = new LinkedList();
                this.tmpAttributeSet.clear();
                this.tmpAggregatorFeatures.clear();
                this.tmpAggregatorParameters.clear();
                this.destinationFV = null;
                this.destinationFK = null;
                this.tagType = 0;
                break;
            }
            case 2: {
                this.tagType = 1;
                break;
            }
            case 3: {
                File file = new File(this.fileName);
                this.fileSet.add(file);
                this.tagType = 2;
                break;
            }
            case 4: {
                this.tagType = 1;
                break;
            }
            case 5: {
                this.tagType = 4;
                break;
            }
            case 6: {
                this.tagType = 4;
                break;
            }
            case 7: {
                this.tagType = 4;
                break;
            }
            case 8: {
                this.tagType = 4;
                break;
            }
            case 9: {
                this.tagType = 4;
                break;
            }
            case 10: {
                this.tagType = 4;
                break;
            }
            case 11: {
                this.tagType = 4;
                break;
            }
            case 12: {
                this.tagType = 4;
                this.featureAttributeSet.put(this.featureName, this.tmpAttributeSet.toArray(new String[0]));
                this.tmpAttributeSet.clear();
                break;
            }
            case 13: {
                this.tagType = 12;
                break;
            }
            case 14: {
                this.tagType = 12;
                break;
            }
            case 15: {
                this.tagType = 1;
                break;
            }
            case 16: {
                this.tagType = 12;
                break;
            }
            case 17: {
                this.aggregatorFeatures.add(this.tmpAggregatorFeatures.toArray(new String[0]));
                this.tmpAggregatorFeatures.clear();
                this.aggregatorParameters.add(this.tmpAggregatorParameters.toArray(new String[0]));
                this.tmpAggregatorParameters.clear();
                this.tagType = 4;
                break;
            }
            case 18: {
                this.tagType = 17;
                break;
            }
            case 19: {
                this.tagType = 17;
                break;
            }
            case 20: {
                this.tagType = 17;
                break;
            }
            default: {
                throw new SAXException("Unknown tag type " + this.tagType + " in end element");
            }
        }
    }

    public void startDocument() throws SAXException {
        this.fileSet.clear();
        this.batchSet.clear();
        this.activeFeatureSet.clear();
        this.featureAttributeSet.clear();
        this.tmpAttributeSet.clear();
        this.aggregatorList.clear();
        this.aggregatorFeatures.clear();
        this.tmpAggregatorFeatures.clear();
        this.tmpAggregatorParameters.clear();
        this.aggregatorParameters.clear();
        this.tagType = -1;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("batchFile")) {
            this.tagType = 0;
        } else if (string2.equals("batch")) {
            if (attributes.getLength() != 1) {
                throw new SAXException("Batch must have an ID attribute");
            }
            this.name = attributes.getValue(0);
            this.tagType = 1;
        } else if (string2.equals("fileSet")) {
            this.tagType = 2;
        } else if (string2.equals("file")) {
            this.tagType = 3;
            this.fileName = "";
        } else if (string2.equals("settings")) {
            this.tagType = 4;
        } else if (string2.equals("windowSize")) {
            this.tagType = 5;
        } else if (string2.equals("windowOverlap")) {
            this.tagType = 6;
        } else if (string2.equals("samplingRate")) {
            this.tagType = 7;
        } else if (string2.equals("normalise")) {
            this.tagType = 8;
        } else if (string2.equals("perWindowStats")) {
            this.tagType = 9;
        } else if (string2.equals("overallStats")) {
            this.tagType = 10;
        } else if (string2.equals("outputType")) {
            this.tagType = 11;
        } else if (string2.equals("feature")) {
            this.tagType = 12;
        } else if (string2.equals("name")) {
            this.tagType = 16;
        } else if (string2.equals("active")) {
            this.tagType = 13;
        } else if (string2.equals("attribute")) {
            this.tagType = 14;
        } else if (string2.equals("destination")) {
            this.tagType = 15;
        } else if (string2.equals("aggregator")) {
            this.tagType = 17;
        } else if (string2.equals("aggregatorName")) {
            this.tagType = 18;
        } else if (string2.equals("aggregatorFeature")) {
            this.tagType = 19;
        } else if (string2.equals("aggregatorAttribute")) {
            this.tagType = 20;
        } else {
            throw new SAXException("Unknown tag '" + string2 + "'");
        }
    }
}

