/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import java.util.Arrays;

public class AreaMoments
extends Aggregator {
    String[] featureNames = null;
    int[] featureNameIndecis = null;

    public AreaMoments() {
        this.metadata = new AggregatorDefinition("Area Moments", "Calculates the first 10 2D statistical moments for the given features", false, null);
    }

    public void aggregate(double[][][] dArray) {
        int n;
        int n2;
        this.result = new double[10];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n3 = super.calculateOffset(dArray, this.featureNameIndecis);
        int[][] nArray = super.collapseFeatures(dArray, this.featureNameIndecis);
        this.result[0] = 0.0;
        for (n2 = n3; n2 < dArray.length; ++n2) {
            for (n = 0; n < nArray.length; ++n) {
                this.result[0] = this.result[0] + dArray[n2][nArray[n][0]][nArray[n][1]];
            }
        }
        if (this.result[0] == 0.0) {
            Arrays.fill(this.result, 0.0);
        } else {
            for (n2 = n3; n2 < dArray.length; ++n2) {
                for (n = 0; n < nArray.length; ++n) {
                    int n4 = nArray[n][0];
                    int n5 = nArray[n][1];
                    double d10 = dArray[n2][n4][n5] / this.result[0];
                    d9 += d10 * (double)n;
                    d8 += d10 * (double)n2;
                    d7 += d10 * (double)n * (double)n;
                    d6 += d10 * (double)n2 * (double)n;
                    d5 += d10 * (double)n * (double)n;
                    d4 += d10 * (double)n2 * (double)n2 * (double)n2;
                    d3 += d10 * (double)n2 * (double)n * (double)n;
                    d2 += d10 * (double)n2 * (double)n2 * (double)n;
                    d += d10 * (double)n2 * (double)n2 * (double)n2;
                }
            }
            this.result[1] = d9;
            this.result[2] = d8;
            this.result[3] = d7 - d9 * d9;
            this.result[4] = d6 - d9 * d8;
            this.result[5] = d5 - d8 * d8;
            this.result[6] = 2.0 * Math.pow(d9, 3.0) - 3.0 * d9 * d7 + d4;
            this.result[7] = 2.0 * d9 * d6 - d8 * d7 + d7 * d8;
            this.result[8] = 2.0 * d8 * d6 - d9 * d5 + d5 * d9;
            this.result[9] = 2.0 * Math.pow(d8, 3.0) - 3.0 * d8 * d5 + d;
        }
    }

    public Object clone() {
        AreaMoments areaMoments = new AreaMoments();
        if (this.featureNames != null) {
            areaMoments.featureNames = (String[])this.featureNames.clone();
        }
        if (this.featureNameIndecis != null) {
            areaMoments.featureNameIndecis = (int[])this.featureNameIndecis.clone();
        }
        return new AreaMoments();
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    public String[] getFeaturesToApply() {
        return this.featureNames;
    }

    public void init(int[] nArray) throws Exception {
        if (nArray.length != this.featureNames.length) {
            throw new Exception("INTERNAL ERROR (Agggregator.AreaMoments): number of feature indeci does not match number of features");
        }
        this.featureNameIndecis = nArray;
    }

    public void setParameters(String[] stringArray, String[] stringArray2) throws Exception {
        this.featureNames = stringArray;
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + " " + stringArray[i];
        }
        this.definition = new FeatureDefinition("Area Moments: " + string, "2D moments constructed from features " + string + ".", true, 10);
    }
}

