/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.Statistics;
import java.util.Arrays;
import org.oc.ocvolume.dsp.featureExtraction;
import org.oc.ocvolume.dsp.fft;

public class MFCC
extends Aggregator {
    featureExtraction fe = new featureExtraction();
    int index = -1;

    public MFCC() {
        this.metadata = new AggregatorDefinition("MFCC", "Treats the window-by-window data as a 16kHz signal", true, null);
    }

    public void aggregate(double[][][] dArray) {
        int n;
        this.fe.numCepstra = 4;
        for (n = 0; n < dArray.length && dArray[n][this.index] == null; ++n) {
        }
        if (n >= dArray.length) {
            this.result = new double[this.definition.dimensions * 4];
            for (int i = 0; i < this.result.length; ++i) {
                this.result[i] = 0.0;
            }
        } else {
            this.result = new double[dArray[dArray.length - 1][this.index].length * 4];
            this.definition.dimensions = this.result.length;
            int n2 = Statistics.ensureIsPowerOfN(dArray.length - n, 2);
            double[] dArray2 = new double[n2];
            Arrays.fill(dArray2, 0.0);
            for (int i = 0; i < dArray[dArray.length - 1][this.index].length; ++i) {
                Arrays.fill(dArray2, 0.0);
                int n3 = 0;
                while (n3 + n < dArray.length) {
                    dArray2[n3] = dArray[n3 + n][this.index][i];
                    ++n3;
                }
                fft fft2 = new fft();
                double[] dArray3 = new double[dArray2.length];
                fft.computeFFT(dArray2);
                for (int j = 0; j < dArray2.length; ++j) {
                    dArray3[j] = Math.pow(fft.real[j] * fft.real[j] + fft.imag[j] * fft.imag[j], 0.5);
                }
                int[] nArray = this.fe.fftBinIndices(16000.0, dArray3.length);
                double[] dArray4 = this.fe.melFilter(dArray3, nArray);
                double[] dArray5 = this.fe.nonLinearTransformation(dArray4);
                double[] dArray6 = this.fe.cepCoefficients(dArray5);
                for (int j = 0; j < dArray6.length; ++j) {
                    this.result[i * 4 + j] = dArray6[j];
                }
            }
        }
    }

    public Object clone() {
        return new MFCC();
    }

    public String[] getFeaturesToApply() {
        return null;
    }

    public void init(int[] nArray) throws Exception {
        this.index = nArray[0];
    }

    public void setSource(FeatureExtractor featureExtractor) {
        FeatureDefinition featureDefinition = featureExtractor.getFeatureDefinition();
        this.definition = new FeatureDefinition("MFCC: " + featureDefinition.name, featureDefinition.description + System.getProperty("line.separator") + "MFCC of each dimension of this feature", featureDefinition.is_sequential, featureDefinition.dimensions * 4);
    }
}

