/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;

public class MultipleFeatureHistogram
extends Aggregator {
    String[] base = null;
    int[] indecis = null;
    int binsPerDimension;

    public MultipleFeatureHistogram() {
        this.metadata = new AggregatorDefinition("Multiple Feature Histogram", "a histogram of categories of input", false, new String[]{"Number of bins for 1st dimension"});
    }

    public MultipleFeatureHistogram(String[] stringArray, int n) {
        this.base = stringArray;
        String string = "Histogram:";
        String string2 = "Histogram of concurrent changes in";
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + " " + stringArray[i];
            string2 = string2 + " " + stringArray[i];
        }
        this.definition = new FeatureDefinition(string, string2, true, n2);
        this.binsPerDimension = n;
        this.metadata = new AggregatorDefinition("Multiple Feature Histogram", "a histogram of categories of input", false, new String[]{"Number of bins for 1st dimension"});
    }

    public String[] getParamaters() {
        return new String[]{Integer.toString(this.binsPerDimension)};
    }

    public void setParameters(String[] stringArray, String[] stringArray2) throws Exception {
        if (stringArray == null) {
            throw new Exception("MultipleFeatureHistogram requires a list of features to aggregate");
        }
        if (stringArray2.length == 1) {
            try {
                this.binsPerDimension = Integer.parseInt(stringArray2[0]);
                this.base = stringArray;
                String string = "Histogram:";
                String string2 = "Histogram of concurrent changes in";
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + " " + stringArray[i];
                    string2 = string2 + " " + stringArray[i];
                }
                this.definition = new FeatureDefinition(string, string2, true, n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Parameters to MultipleFeatureHistogram must be an integer");
            }
        } else {
            throw new Exception("MultipleFeatureHistogram takes exactly one argument of type integer");
        }
    }

    public void aggregate(double[][][] dArray) throws Exception {
        int[][] nArray = super.collapseFeatures(dArray, this.indecis);
        this.definition.dimensions = (int)Math.pow(this.binsPerDimension, nArray.length);
        if (this.definition.dimensions > 0x100000) {
            throw new Exception("Number of dimensions for " + this.definition.name + " exceeds 1048576 - " + this.definition.dimensions);
        }
        int n = super.calculateOffset(dArray, this.indecis);
        Integer[][] integerArray = new Integer[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = this.assignToBins(dArray, nArray[i][0], nArray[i][1]);
        }
        this.result = this.combineBins(integerArray, n);
    }

    public Object clone() {
        MultipleFeatureHistogram multipleFeatureHistogram = new MultipleFeatureHistogram();
        if (this.base != null) {
            try {
                multipleFeatureHistogram.setParameters(this.base, new String[]{Integer.toString(this.binsPerDimension)});
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return multipleFeatureHistogram;
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    public String[] getFeaturesToApply() {
        return this.base;
    }

    public void init(int[] nArray) throws Exception {
        this.indecis = nArray;
    }

    Integer[] assignToBins(double[][][] dArray, int n, int n2) {
        int n3;
        Integer[] integerArray = new Integer[dArray.length];
        double[] dArray2 = new double[this.binsPerDimension - 1];
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i][n] != null && dArray[i][n][n2] > d) {
                d = dArray[i][n][n2];
            }
            if (dArray[i][n] == null || !(dArray[i][n][n2] < d2)) continue;
            d2 = dArray[i][n][n2];
        }
        double d3 = (d - d2) / (double)this.binsPerDimension;
        dArray2[0] = d2 + d3;
        for (n3 = 1; n3 < dArray2.length; ++n3) {
            dArray2[n3] = dArray2[n3 - 1] + d3;
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            if (dArray[n3][n] == null) {
                integerArray[n3] = null;
                continue;
            }
            integerArray[n3] = null;
            for (int i = 0; i < dArray2.length; ++i) {
                if (!(dArray[n3][n][n2] < dArray2[i])) continue;
                integerArray[n3] = new Integer(i);
                break;
            }
            if (integerArray[n3] != null) continue;
            integerArray[n3] = new Integer(this.binsPerDimension - 1);
        }
        return integerArray;
    }

    double[] combineBins(Integer[][] integerArray, int n) {
        int n2;
        int n3 = (int)Math.pow(this.binsPerDimension, integerArray.length);
        double[] dArray = new double[n3];
        for (n2 = n; n2 < integerArray[0].length; ++n2) {
            int n4 = 0;
            int n5 = 1;
            for (int i = 0; i < integerArray.length; ++i) {
                n4 += integerArray[i][n2] * n5;
                n5 *= this.binsPerDimension;
            }
            int n6 = n4;
            dArray[n6] = dArray[n6] + 1.0;
        }
        n2 = 0;
        while (n2 < dArray.length) {
            int n7 = n2++;
            dArray[n7] = dArray[n7] / (double)(integerArray[0].length - n);
        }
        return dArray;
    }
}

