/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.Aggregators;

import jAudioFeatureExtractor.ACE.DataTypes.AggregatorDefinition;
import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class StandardDeviation
extends Aggregator {
    int feature = -1;

    public StandardDeviation() {
        this.metadata = new AggregatorDefinition("Standard Deviation", "Standard Deviation of the window-by-window data", true, null);
    }

    public void aggregate(double[][][] dArray) {
        if (dArray[dArray.length - 1][this.feature] == null) {
            this.definition.dimensions = 1;
            this.result = new double[]{0.0};
        } else {
            int n;
            this.definition.dimensions = n = dArray[dArray.length - 1][this.feature].length;
            this.result = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = 0;
                double d = 0.0;
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    if (dArray[n2][this.feature] == null || dArray[n2][this.feature].length <= i) continue;
                    d += dArray[n2][this.feature][i];
                    ++n3;
                }
                if (n3 < 2) {
                    this.result[i] = 0.0;
                    continue;
                }
                d /= (double)n3;
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    if (dArray[n2][this.feature] == null || dArray[n2][this.feature].length <= i) continue;
                    int n4 = i;
                    this.result[n4] = this.result[n4] + Math.pow(dArray[n2][this.feature][i] - d, 2.0);
                }
                this.result[i] = Math.sqrt(this.result[i] / ((double)n3 - 1.0));
            }
        }
    }

    public Object clone() {
        return new StandardDeviation();
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.definition;
    }

    public String[] getFeaturesToApply() {
        return null;
    }

    public void init(int[] nArray) throws Exception {
        this.feature = nArray[0];
    }

    public void setSource(FeatureExtractor featureExtractor) {
        FeatureDefinition featureDefinition = featureExtractor.getFeatureDefinition();
        this.definition = new FeatureDefinition(featureDefinition.name + " Overall Standard Deviation", featureDefinition.description + LINE_SEP + "This is the overall standard deviation over all windows.", featureDefinition.is_sequential, featureDefinition.dimensions);
    }
}

