/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class HarmonicSpectralFlux
extends FeatureExtractor {
    public HarmonicSpectralFlux() {
        String string = new String("Partial Based Spectral Flux");
        String string2 = new String("Cacluate the correlation bettween adjacent frames based peaks instead of spectral bins.  Peak tracking is primitive - whe the number of bins changes, the bottom bins are matched sequentially and the extra unmatched bins are ignored.");
        this.definition = new FeatureDefinition(string, string2, true, 1);
        this.dependencies = new String[]{"Peak Detection", "Peak Detection"};
        this.offsets = new int[]{0, -1};
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) {
        double[] dArray3 = new double[1];
        double[] dArray4 = dArray2[1];
        double[] dArray5 = dArray2[0];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = Math.min(dArray4.length, dArray5.length);
        for (int i = 0; i < n; ++i) {
            d6 += dArray4[i];
            d5 += dArray5[i];
            d4 += dArray4[i] * dArray5[i];
            d3 = dArray4[i] * dArray4[i];
            d2 = dArray5[i] * dArray5[i];
        }
        double d7 = d4 - d6 * d5 / (double)n;
        double d8 = Math.sqrt(Math.abs((d3 - d6 * d6 / (double)n) * (d2 - d5 * d5 / (double)n)));
        dArray3[0] = d7 / d8;
        return dArray3;
    }

    public Object clone() {
        return new HarmonicSpectralFlux();
    }
}

