/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import java.util.LinkedList;

public class PeakFinder
extends FeatureExtractor {
    int peakThreshold = 10;

    public PeakFinder() {
        String string = "Peak Detection";
        String string2 = "All peaks that are within an order of magnitude of the highest point";
        this.definition = new FeatureDefinition(string, string2, true, 0, new String[]{"Threshold for peak detection"});
        this.dependencies = new String[]{"Magnitude Spectrum"};
        this.offsets = new int[]{0};
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        boolean bl = false;
        double d2 = 0.0;
        double[] dArray3 = dArray2[0];
        for (int i = 0; i < dArray2[0].length; ++i) {
            if (!(dArray2[0][i] > d2)) continue;
            d2 = dArray2[0][i];
        }
        d2 /= (double)this.peakThreshold;
        LinkedList<Double> linkedList = new LinkedList<Double>();
        for (int i = 1; i < dArray3.length - 1; ++i) {
            if (!(dArray3[i - 1] < dArray3[i]) || !(dArray3[i + 1] < dArray3[i]) || !(dArray3[i] > d2)) continue;
            linkedList.add(dArray3[i]);
        }
        Double[] doubleArray = linkedList.toArray(new Double[0]);
        double[] dArray4 = new double[doubleArray.length];
        for (int i = 0; i < dArray4.length; ++i) {
            dArray4[i] = doubleArray[i];
        }
        return dArray4;
    }

    public String getElement(int n) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: PeakFinder index != 0 (" + n + ")");
        }
        return Integer.toString(this.peakThreshold);
    }

    public void setPeakThreshold(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("PeakFinder peakThreshold must be a positive value.");
        }
        this.peakThreshold = n;
    }

    public void setElement(int n, String string) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: PeakFinder index != 0 (" + n + ")");
        }
        try {
            this.setPeakThreshold(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Peak Threshold Must be an integer");
        }
    }

    public Object clone() {
        PeakFinder peakFinder = new PeakFinder();
        try {
            peakFinder.setPeakThreshold(this.peakThreshold);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return peakFinder;
    }
}

