/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class SpectralRolloffPoint
extends FeatureExtractor {
    protected double cutoff = 0.85;

    public SpectralRolloffPoint() {
        String string = "Spectral Rolloff Point";
        String string2 = "The fraction of bins in the power spectrum at which 85% of the power is at lower frequencies. This is a measure of the right-skewedness of the power spectrum.";
        boolean bl = true;
        int n = 1;
        this.definition = new FeatureDefinition(string, string2, bl, n, new String[]{"Cutoff point (0-1)"});
        this.dependencies = new String[1];
        this.dependencies[0] = "Power Spectrum";
        this.offsets = new int[1];
        this.offsets[0] = 0;
    }

    public double[] extractFeature(double[] dArray, double d, double[][] dArray2) throws Exception {
        double[] dArray3 = dArray2[0];
        double d2 = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d2 += dArray3[i];
        }
        double d3 = d2 * this.cutoff;
        d2 = 0.0;
        int n = 0;
        for (int i = 0; i < dArray3.length; ++i) {
            if (!((d2 += dArray3[i]) >= d3)) continue;
            n = i;
            i = dArray3.length;
        }
        double[] dArray4 = new double[]{(double)n / (double)dArray3.length};
        return dArray4;
    }

    public Object clone() {
        SpectralRolloffPoint spectralRolloffPoint = new SpectralRolloffPoint();
        spectralRolloffPoint.cutoff = this.cutoff;
        return spectralRolloffPoint;
    }

    public String getElement(int n) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to AreaMoments:getElement");
        }
        return Double.toString(this.cutoff);
    }

    public void setElement(int n, String string) throws Exception {
        if (n != 0) {
            throw new Exception("INTERNAL ERROR: invalid index " + n + " sent to AreaMoments:setElement");
        }
        try {
            double d = Double.parseDouble(string);
            this.setCutoff(d);
        }
        catch (Exception exception) {
            throw new Exception("Length of Area Method of Moments must be an integer");
        }
    }

    public void setCutoff(double d) throws Exception {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new Exception("SpectralRolloff cutoff must be a real number");
        }
        if (d <= 0.0 || d >= 1.0) {
            throw new Exception("SpectralRolloff cutoff must be gretaer than 0 and less than 1");
        }
        this.cutoff = d;
    }
}

