/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.BatchProgressFrame;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.ErrorGUI;
import jAudioFeatureExtractor.ModelListener;
import jAudioFeatureExtractor.OuterFrame;
import jAudioFeatureExtractor.Updater;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class BatchExecutionThread
extends Thread
implements Updater {
    Runnable suspendGUI;
    Runnable resumeGUI;
    RestoreSettings restoreSettings;
    BatchProgressFrame batchProgressFrame;
    UpdateGUI updateGui;
    ErrorGUI errorGUI;
    UpdateGUI updateGUI;
    OuterFrame outerFrame;
    Controller controller;
    FeatureExtractor[] features;
    boolean[] defaults;
    Vector<Batch> batches;
    boolean hasRun = false;

    public BatchExecutionThread(Controller controller, OuterFrame outerFrame) {
        this.outerFrame = outerFrame;
        this.controller = controller;
        this.batchProgressFrame = new BatchProgressFrame();
        this.batchProgressFrame.setVisible(true);
        this.errorGUI = new ErrorGUI(this.batchProgressFrame);
        this.updateGUI = new UpdateGUI();
        this.suspendGUI = new Runnable(){

            public void run() {
                BatchExecutionThread.this.outerFrame.setEnabled(false);
            }
        };
        this.resumeGUI = new Runnable(){

            public void run() {
                BatchExecutionThread.this.outerFrame.setEnabled(true);
            }
        };
        this.restoreSettings = new RestoreSettings();
        this.updateGUI = new UpdateGUI();
        controller.dm_.setUpdater(this);
        this.restoreSettings.fe = (FeatureExtractor[])controller.dm_.features.clone();
        this.restoreSettings.d = (boolean[])controller.dm_.defaults.clone();
        this.restoreSettings.c = controller;
    }

    public void run() {
        ModelListener modelListener = this.controller.dm_.ml_;
        this.controller.dm_.ml_ = null;
        try {
            SwingUtilities.invokeAndWait(this.suspendGUI);
            for (int i = 0; i < this.controller.batches.size(); ++i) {
                File file = new File(this.controller.batches.get(i).getDestinationFV());
                File file2 = new File(this.controller.batches.get(i).getDestinationFK());
                this.controller.dm_.featureKey = new FileOutputStream(file);
                this.controller.dm_.featureValue = new FileOutputStream(file2);
                this.controller.batches.get(i).execute();
                this.updateGUI.incrementBatch();
                SwingUtilities.invokeLater(this.updateGUI);
            }
            SwingUtilities.invokeLater(this.resumeGUI);
        }
        catch (Exception exception) {
            this.errorGUI.e = exception;
            SwingUtilities.invokeLater(this.errorGUI);
            SwingUtilities.invokeLater(this.resumeGUI);
        }
        this.hasRun = true;
        this.batchProgressFrame.setVisible(false);
        this.controller.dm_.ml_ = modelListener;
        try {
            SwingUtilities.invokeAndWait(this.restoreSettings);
            BatchExecutionThread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("INTERNAL ERROR: " + interruptedException.getMessage());
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("INTERNAL ERROR: " + invocationTargetException.getMessage());
            invocationTargetException.printStackTrace();
        }
    }

    public void announceUpdate(int n, int n2) {
        this.updateGUI.setPos(n, n2);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    public void announceUpdate(int n) {
        this.updateGUI.setPos(n);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    public void setNumberOfFiles(int n) {
        this.updateGUI.setLengths(n);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    public void setFileLength(int n) {
        this.updateGUI.setMaxWindows(n);
        SwingUtilities.invokeLater(this.updateGUI);
    }

    class RestoreSettings
    implements Runnable {
        public Controller c;
        public FeatureExtractor[] fe;
        public boolean[] d;

        RestoreSettings() {
        }

        public void run() {
            for (int i = 0; i < this.fe.length; ++i) {
                int n = this.fe[i].getFeatureDefinition().attributes.length;
                for (int j = 0; j < n; ++j) {
                    try {
                        this.c.dm_.features[i].setElement(j, this.fe[i].getElement(j));
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("INTERNAL ERROR: " + exception.getMessage());
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    class UpdateGUI
    implements Runnable {
        int numberOfFiles;
        int file;
        int thisFileLength = 0;
        int pos;
        int batch = 0;

        UpdateGUI() {
        }

        public void setLengths(int n) {
            this.numberOfFiles = n;
        }

        public void setMaxWindows(int n) {
            this.thisFileLength = n;
        }

        public void setPos(int n, int n2) {
            this.file = n;
            this.pos = n2;
        }

        public void setPos(int n) {
            this.pos = n;
        }

        public void incrementBatch() {
            ++this.batch;
        }

        public void run() {
            BatchExecutionThread.this.batchProgressFrame.setVisible(true);
            BatchExecutionThread.this.batchProgressFrame.fileProgressBar.setMaximum(this.thisFileLength);
            BatchExecutionThread.this.batchProgressFrame.batchProgressBar.setMaximum(this.numberOfFiles);
            BatchExecutionThread.this.batchProgressFrame.overallProgressBar.setMaximum(BatchExecutionThread.this.controller.batches.size());
            BatchExecutionThread.this.batchProgressFrame.fileProgressBar.setValue(this.pos);
            BatchExecutionThread.this.batchProgressFrame.batchProgressBar.setValue(this.file);
            BatchExecutionThread.this.batchProgressFrame.overallProgressBar.setValue(this.batch);
        }
    }
}

