/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.FeatureSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class EditFeatures
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private FeatureSelectorPanel parent_;
    private JTextArea[] inputBoxes;
    private JLabel[] inputBoxLabels;
    private JLabel descriptionTitle;
    private JTextArea infoLabel;
    private JButton save;
    private JButton cancel;
    private int row;
    private FeatureExtractor fe_;

    EditFeatures(FeatureSelectorPanel featureSelectorPanel, FeatureExtractor featureExtractor) {
        this.setTitle("Edit " + featureExtractor.getFeatureDefinition().name);
        Color color = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(color);
        this.setAlwaysOnTop(true);
        String[] stringArray = featureExtractor.getFeatureDefinition().attributes;
        this.fe_ = featureExtractor;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EditFeatures.this.cancel();
            }
        });
        this.inputBoxes = new JTextArea[stringArray.length];
        this.inputBoxLabels = new JLabel[stringArray.length];
        for (int i = 0; i < this.inputBoxes.length; ++i) {
            this.inputBoxes[i] = new JTextArea();
            try {
                this.inputBoxes[i].setText(this.fe_.getElement(i));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
            }
            this.inputBoxLabels[i] = new JLabel(stringArray[i]);
        }
        this.descriptionTitle = new JLabel("Description");
        this.infoLabel = new JTextArea(featureExtractor.getFeatureDefinition().description);
        this.infoLabel.setWrapStyleWord(true);
        this.infoLabel.setLineWrap(true);
        this.infoLabel.setEditable(false);
        this.infoLabel.setBackground(this.getContentPane().getBackground());
        Dimension dimension = new Dimension(400, 100);
        this.infoLabel.setPreferredSize(dimension);
        this.save = new JButton("Save");
        this.save.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setBackground(color);
        jPanel.setLayout(new GridLayout(this.inputBoxLabels.length, 2, 6, 11));
        for (int i = 0; i < this.inputBoxLabels.length; ++i) {
            jPanel.add(this.inputBoxes[i]);
            jPanel.add(this.inputBoxLabels[i]);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        jPanel2.setBackground(color);
        jPanel2.setLayout(new GridLayout(1, 2, 6, 11));
        jPanel2.add(this.save);
        jPanel2.add(this.cancel);
        this.add((Component)jPanel2, "South");
        jPanel3.setBackground(color);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.descriptionTitle, "North");
        jPanel3.add((Component)this.infoLabel, "Center");
        this.add((Component)jPanel3, "Center");
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.cancel)) {
            this.cancel();
        } else if (actionEvent.getSource().equals(this.save)) {
            this.save();
        }
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void save() {
        boolean bl = true;
        for (int i = 0; i < this.inputBoxes.length; ++i) {
            try {
                this.fe_.setElement(i, this.inputBoxes[i].getText());
                continue;
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
                JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
            }
        }
        if (bl) {
            this.setVisible(false);
        }
    }

    void setRow(int n) {
        this.row = n;
    }
}

