/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.GeneralTools;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class PlotDisplay
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private double x_min;
    private double x_max;
    private double y_min;
    private double y_max;
    private double x_tic_interval;
    private double y_tic_interval;
    private JTextField x_min_tf;
    private JTextField x_max_tf;
    private JTextField y_min_tf;
    private JTextField y_max_tf;
    private JTextField x_tic_interval_tf;
    private JTextField y_tic_interval_tf;
    private Canvas[] canvases;
    private double[][] data_points;
    private double[][] data_x_coordinates;

    public PlotDisplay(double[][] dArray, double[][] dArray2, boolean bl, String string, boolean bl2) throws Exception {
        int n;
        int n2;
        int n3;
        this.data_points = dArray;
        this.data_x_coordinates = dArray2;
        if (this.data_points == null) {
            throw new Exception("No data points were provided to plot.");
        }
        if (this.data_points.length > 5) {
            throw new Exception("More than five data sets specified.");
        }
        for (n3 = 0; n3 < this.data_points.length; ++n3) {
            if (this.data_points[n3] != null) continue;
            throw new Exception("Data set " + n3 + " is empty.");
        }
        if (this.data_x_coordinates != null) {
            if (this.data_points.length != this.data_x_coordinates.length) {
                throw new Exception("There are a different number of data sets\nand data set labels.");
            }
            for (n3 = 0; n3 < this.data_points.length; ++n3) {
                if (this.data_points[n3].length == this.data_x_coordinates[n3].length) continue;
                throw new Exception("Data set " + n3 + " has a different number\n" + "of data points and x-coodinate labels.");
            }
        }
        if (this.data_x_coordinates == null) {
            this.data_x_coordinates = new double[this.data_points.length][];
            for (n3 = 0; n3 < this.data_points.length; ++n3) {
                this.data_x_coordinates[n3] = new double[this.data_points[n3].length];
                for (n2 = 0; n2 < this.data_points[n3].length; ++n2) {
                    this.data_x_coordinates[n3][n2] = n2;
                }
            }
        }
        this.x_min = this.data_x_coordinates[0][0];
        this.x_max = this.data_x_coordinates[0][0];
        this.y_min = this.data_points[0][0];
        this.y_max = this.data_points[0][0];
        for (n3 = 0; n3 < this.data_points.length; ++n3) {
            for (n2 = 0; n2 < this.data_points[n3].length; ++n2) {
                if (this.data_points[n3][n2] < this.y_min) {
                    this.y_min = this.data_points[n3][n2];
                }
                if (this.data_points[n3][n2] > this.y_max) {
                    this.y_max = this.data_points[n3][n2];
                }
                if (this.data_x_coordinates[n3][n2] < this.x_min) {
                    this.x_min = this.data_x_coordinates[n3][n2];
                }
                if (!(this.data_x_coordinates[n3][n2] > this.x_max)) continue;
                this.x_max = this.data_x_coordinates[n3][n2];
            }
        }
        if (this.y_min < 0.0) {
            this.y_min -= Math.abs(this.y_min * 0.05);
        }
        this.y_max += Math.abs(this.y_max * 0.05);
        this.x_tic_interval = 10.0;
        this.y_tic_interval = 0.1;
        this.x_min_tf = new JTextField("" + this.x_min, 7);
        this.x_max_tf = new JTextField("" + this.x_max, 7);
        this.y_min_tf = new JTextField("" + this.y_min, 7);
        this.y_max_tf = new JTextField("" + this.y_max, 7);
        this.x_tic_interval_tf = new JTextField("" + this.x_tic_interval, 7);
        this.y_tic_interval_tf = new JTextField("" + this.y_tic_interval, 7);
        Color color = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(color);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 4));
        jPanel.setBorder(new EtchedBorder());
        jPanel.setBackground(this.getContentPane().getBackground());
        JButton jButton = new JButton("Replot");
        jButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Minimum X"));
        jPanel2.add(this.x_min_tf);
        jPanel2.setBackground(this.getContentPane().getBackground());
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("Maximum X"));
        jPanel3.add(this.x_max_tf);
        jPanel3.setBackground(this.getContentPane().getBackground());
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel("Minimum Y"));
        jPanel4.add(this.y_min_tf);
        jPanel4.setBackground(this.getContentPane().getBackground());
        JPanel jPanel5 = new JPanel();
        jPanel5.add(new JLabel("Maximum Y"));
        jPanel5.add(this.y_max_tf);
        jPanel5.setBackground(this.getContentPane().getBackground());
        JPanel jPanel6 = new JPanel();
        jPanel6.add(new JLabel("X Tic Interval"));
        jPanel6.add(this.x_tic_interval_tf);
        jPanel6.setBackground(this.getContentPane().getBackground());
        JPanel jPanel7 = new JPanel();
        jPanel7.add(new JLabel("Y Tic Interval"));
        jPanel7.add(this.y_tic_interval_tf);
        jPanel7.setBackground(this.getContentPane().getBackground());
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        jPanel.add(jPanel6);
        jPanel.add(jPanel7);
        jPanel.add(new JLabel(""));
        jPanel.add(jButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(0, 1));
        if (!bl) {
            this.canvases = new Canvas[this.data_points.length];
            for (n = 0; n < this.data_points.length; ++n) {
                this.canvases[n] = new PlotCanvas(n, false);
                if (n % 2 == 0) {
                    this.canvases[n].setBackground(Color.WHITE);
                } else {
                    this.canvases[n].setBackground(Color.LIGHT_GRAY);
                }
                jPanel8.add(this.canvases[n]);
            }
        } else {
            this.canvases = new Canvas[1];
            this.canvases[0] = new PlotCanvas(0, true);
            this.canvases[0].setBackground(Color.WHITE);
            jPanel8.add(this.canvases[0]);
        }
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)jPanel8, "Center");
        if (bl2) {
            this.setDefaultCloseOperation(3);
        } else {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PlotDisplay.this.end();
                }
            });
        }
        n = 800;
        int n4 = 500;
        this.setBounds(0, 0, n, n4);
        if (string == null) {
            string = new String("Data Plot");
        }
        this.setTitle(string);
        this.setVisible(true);
        for (int i = 0; i < this.canvases.length; ++i) {
            this.canvases[i].repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.x_min = Double.parseDouble(this.x_min_tf.getText());
            this.x_max = Double.parseDouble(this.x_max_tf.getText());
            this.y_min = Double.parseDouble(this.y_min_tf.getText());
            this.y_max = Double.parseDouble(this.y_max_tf.getText());
            this.x_tic_interval = Double.parseDouble(this.x_tic_interval_tf.getText());
            this.y_tic_interval = Double.parseDouble(this.y_tic_interval_tf.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Invalid text option: " + numberFormatException.getMessage(), "ERROR", 0);
        }
        for (int i = 0; i < this.canvases.length; ++i) {
            this.canvases[i].repaint();
        }
    }

    private void end() {
        this.setVisible(false);
        this.data_points = null;
        this.data_x_coordinates = null;
        this.dispose();
        this.canvases = null;
        System.gc();
    }

    private class PlotCanvas
    extends Canvas {
        static final long serialVersionUID = 1L;
        private double x_scale;
        private double y_scale;
        private int data_set_index;
        private double x_tic_length;
        private double y_tic_length;
        private boolean plot_on_one_graph;

        public PlotCanvas(int n, boolean bl) {
            this.data_set_index = n;
            this.plot_on_one_graph = bl;
        }

        public void paint(Graphics graphics) {
            int n = PlotDisplay.this.canvases[this.data_set_index].getWidth();
            int n2 = PlotDisplay.this.canvases[this.data_set_index].getHeight();
            this.x_scale = (double)n / (PlotDisplay.this.x_max - PlotDisplay.this.x_min);
            this.y_scale = (double)n2 / (PlotDisplay.this.y_max - PlotDisplay.this.y_min);
            this.x_tic_length = (PlotDisplay.this.y_max - PlotDisplay.this.y_min) / 35.0;
            this.y_tic_length = (PlotDisplay.this.x_max - PlotDisplay.this.x_min) / 100.0;
            graphics.translate((int)((0.0 - PlotDisplay.this.x_min) * this.x_scale), (int)((0.0 - PlotDisplay.this.y_min) * this.y_scale));
            this.drawAxes(graphics);
            graphics.setColor(Color.BLACK);
            if (!this.plot_on_one_graph) {
                int n3 = this.scaleX(PlotDisplay.this.data_x_coordinates[this.data_set_index][0]);
                int n4 = this.scaleY(PlotDisplay.this.data_points[this.data_set_index][0]);
                for (int i = 0; i < PlotDisplay.this.data_points[this.data_set_index].length; ++i) {
                    int n5 = this.scaleX(PlotDisplay.this.data_x_coordinates[this.data_set_index][i]);
                    int n6 = this.scaleY(PlotDisplay.this.data_points[this.data_set_index][i]);
                    graphics.drawLine(n3, n4, n5, n6);
                    n3 = n5;
                    n4 = n6;
                }
            } else {
                for (int i = 0; i < PlotDisplay.this.data_points.length; ++i) {
                    int n7 = this.scaleX(PlotDisplay.this.data_x_coordinates[i][0]);
                    int n8 = this.scaleY(PlotDisplay.this.data_points[i][0]);
                    for (int j = 0; j < PlotDisplay.this.data_points[i].length; ++j) {
                        int n9 = this.scaleX(PlotDisplay.this.data_x_coordinates[i][j]);
                        int n10 = this.scaleY(PlotDisplay.this.data_points[i][j]);
                        graphics.drawLine(n7, n8, n9, n10);
                        n7 = n9;
                        n8 = n10;
                    }
                }
            }
        }

        private void drawAxes(Graphics graphics) {
            graphics.setColor(Color.RED);
            String string = "" + PlotDisplay.this.x_max;
            char[] cArray = string.toCharArray();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(cArray, 0, cArray.length, graphics);
            int n = (int)rectangle2D.getWidth();
            int n2 = (int)rectangle2D.getHeight();
            if (PlotDisplay.this.x_min <= 0.0 && PlotDisplay.this.x_max >= 0.0) {
                graphics.drawLine(this.scaleX(0.0), this.scaleY(PlotDisplay.this.y_min), this.scaleX(0.0), this.scaleY(PlotDisplay.this.y_max));
                graphics.drawString("" + PlotDisplay.this.y_min, this.scaleX(this.y_tic_length / 2.0) + 2, this.scaleY(PlotDisplay.this.y_min));
                graphics.drawString("" + PlotDisplay.this.y_max, this.scaleX(this.y_tic_length / 2.0) + 2, this.scaleY(PlotDisplay.this.y_max) + n2);
            } else if (PlotDisplay.this.x_min > 0.0) {
                graphics.drawLine(this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min), this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_max));
                graphics.drawString("" + PlotDisplay.this.y_min, this.scaleX(PlotDisplay.this.x_min + this.y_tic_length / 2.0) + 2, this.scaleY(PlotDisplay.this.y_min));
                graphics.drawString("" + PlotDisplay.this.y_max, this.scaleX(PlotDisplay.this.x_min + this.y_tic_length / 2.0) + 2, this.scaleY(PlotDisplay.this.y_max) + n2);
            } else if (PlotDisplay.this.x_max < 0.0) {
                graphics.drawLine(this.scaleX(PlotDisplay.this.x_max), this.scaleY(PlotDisplay.this.y_min), this.scaleX(PlotDisplay.this.x_max), this.scaleY(PlotDisplay.this.y_max));
                graphics.drawString("" + PlotDisplay.this.y_min, this.scaleX(PlotDisplay.this.x_max - this.y_tic_length / 2.0) - 20, this.scaleY(PlotDisplay.this.y_min));
                graphics.drawString("" + PlotDisplay.this.y_max, this.scaleX(PlotDisplay.this.x_max - this.y_tic_length / 2.0) - 20, this.scaleY(PlotDisplay.this.y_max) + n2);
            }
            if (PlotDisplay.this.y_min <= 0.0 && PlotDisplay.this.y_max >= 0.0) {
                graphics.drawLine(this.scaleX(PlotDisplay.this.x_min), this.scaleY(0.0), this.scaleX(PlotDisplay.this.x_max), this.scaleY(0.0));
                graphics.drawString("" + PlotDisplay.this.x_min, this.scaleX(PlotDisplay.this.x_min), this.scaleY(this.x_tic_length / 2.0) - 2);
                graphics.drawString(string, this.scaleX(PlotDisplay.this.x_max) - n, this.scaleY(this.x_tic_length / 2.0) - 2);
            } else if (PlotDisplay.this.y_min > 0.0) {
                graphics.drawLine(this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min) - 1, this.scaleX(PlotDisplay.this.x_max), this.scaleY(PlotDisplay.this.y_min) - 1);
                graphics.drawString("" + PlotDisplay.this.x_min, this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0) - 2);
                graphics.drawString(string, this.scaleX(PlotDisplay.this.x_max) - n, this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0) - 2);
            } else if (PlotDisplay.this.y_max < 0.0) {
                graphics.drawLine(this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min) - 1, this.scaleX(PlotDisplay.this.x_max), this.scaleY(PlotDisplay.this.y_min) - 1);
                graphics.drawString("" + PlotDisplay.this.x_min, this.scaleX(PlotDisplay.this.x_min), this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0) - 2);
                graphics.drawString(string, this.scaleX(PlotDisplay.this.x_max) - n, this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0) - 2);
            }
            this.drawXTics(graphics);
            this.drawYTics(graphics);
        }

        private void drawXTics(Graphics graphics) {
            double d;
            int n;
            int n2;
            if (PlotDisplay.this.y_min <= 0.0 && PlotDisplay.this.y_max >= 0.0) {
                n2 = this.scaleY(this.x_tic_length / 2.0);
                n = this.scaleY(-this.x_tic_length / 2.0);
            } else {
                n2 = this.scaleY(PlotDisplay.this.y_min + this.x_tic_length / 2.0);
                n = this.scaleY(PlotDisplay.this.y_min);
            }
            int n3 = 0;
            for (d = 0.0; d < PlotDisplay.this.x_max; d += PlotDisplay.this.x_tic_interval) {
                n3 = this.scaleX(d);
                graphics.drawLine(n3, n2, n3, n);
            }
            for (d = 0.0; d > PlotDisplay.this.x_min; d -= PlotDisplay.this.x_tic_interval) {
                n3 = this.scaleX(d);
                graphics.drawLine(n3, n2, n3, n);
            }
        }

        private void drawYTics(Graphics graphics) {
            double d;
            int n = 0;
            int n2 = 0;
            if (PlotDisplay.this.x_min <= 0.0 && PlotDisplay.this.x_max >= 0.0) {
                n = this.scaleX(-this.y_tic_length / 2.0);
                n2 = this.scaleX(this.y_tic_length / 2.0);
            } else if (PlotDisplay.this.x_min >= 0.0) {
                n = this.scaleX(PlotDisplay.this.x_min);
                n2 = this.scaleX(PlotDisplay.this.x_min + this.y_tic_length / 2.0);
            } else if (PlotDisplay.this.x_max <= 0.0) {
                n = this.scaleX(PlotDisplay.this.x_max);
                n2 = this.scaleX(PlotDisplay.this.x_max - this.y_tic_length / 2.0);
            }
            int n3 = 0;
            for (d = 0.0; d < PlotDisplay.this.y_max; d += PlotDisplay.this.y_tic_interval) {
                n3 = this.scaleY(d);
                graphics.drawLine(n2, n3, n, n3);
            }
            for (d = 0.0; d > PlotDisplay.this.y_min; d -= PlotDisplay.this.y_tic_interval) {
                n3 = this.scaleY(d);
                graphics.drawLine(n2, n3, n, n3);
            }
        }

        private int scaleX(double d) {
            return (int)(d * this.x_scale);
        }

        private int scaleY(double d) {
            double d2 = PlotDisplay.this.y_max + PlotDisplay.this.y_min - d;
            return (int)(d2 * this.y_scale);
        }
    }
}

