/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.GeneralTools;

public class Statistics {
    public static double getAverage(double[] dArray) {
        if (dArray.length < 1) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    public static double getAverage(int[] nArray) {
        if (nArray.length < 1) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)nArray[i];
        }
        return d / (double)nArray.length;
    }

    public static double getStandardDeviation(double[] dArray) {
        if (dArray.length < 2) {
            return 0.0;
        }
        double d = Statistics.getAverage(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i] - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(dArray.length - 1));
    }

    public static double getStandardDeviation(int[] nArray) {
        if (nArray.length < 2) {
            return 0.0;
        }
        double d = Statistics.getAverage(nArray);
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d3 = (double)nArray[i] - d;
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)(nArray.length - 1));
    }

    public static boolean isFactorOrMultiple(int n, int n2, int[] nArray) {
        boolean bl = false;
        if (n2 > n) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n * nArray[i] != n2) continue;
                bl = true;
                i = nArray.length + 1;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 * nArray[i] != n) continue;
                bl = true;
                i = nArray.length + 1;
            }
        }
        return bl;
    }

    public static int getIndexOfLargest(double[] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        return n;
    }

    public static int getIndexOfSmallest(double[] dArray) {
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < dArray[n])) continue;
            n = i;
        }
        return n;
    }

    public static int getIndexOfLargest(float[] fArray) {
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] > fArray[n])) continue;
            n = i;
        }
        return n;
    }

    public static int getIndexOfLargest(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= nArray[n]) continue;
            n = i;
        }
        return n;
    }

    public static double calculateEuclideanDistance(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("The two given arrays have different sizes.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.pow(dArray[i] - dArray2[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public static int generateRandomNumber(int n) {
        int n2 = (int)(2.147483647E9 * Math.random());
        return n2 % n;
    }

    public static int[] getRandomOrdering(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.random();
        }
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            nArray[i] = n2 = Statistics.getIndexOfLargest(dArray);
            dArray[n2] = -1.0;
        }
        return nArray;
    }

    public static double getArraySum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double[] normalize(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i];
        }
        double d = Statistics.getArraySum(dArray2);
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray2[i] / d;
        }
        return dArray2;
    }

    public static double[][] normalize(double[][] dArray) {
        int n;
        int n2;
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[dArray[i].length];
            for (n2 = 0; n2 < dArrayArray[i].length; ++n2) {
                dArrayArray[i][n2] = dArray[i][n2];
            }
        }
        double[] dArray2 = new double[dArrayArray.length];
        for (n2 = 0; n2 < dArrayArray.length; ++n2) {
            dArray2[n2] = 0.0;
            for (n = 0; n < dArrayArray[n2].length; ++n) {
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + dArrayArray[n2][n];
            }
        }
        for (n2 = 0; n2 < dArrayArray.length; ++n2) {
            for (n = 0; n < dArrayArray[n2].length; ++n) {
                dArrayArray[n2][n] = dArrayArray[n2][n] / dArray2[n2];
            }
        }
        return dArrayArray;
    }

    public static int pow(int n, int n2) {
        int n3 = n;
        for (int i = 1; i < n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public static double logBaseN(double d, double d2) {
        return Math.log10(d) / Math.log10(d2);
    }

    public static int ensureIsPowerOfN(int n, int n2) {
        double d = Statistics.logBaseN(n, n2);
        int n3 = (int)d;
        int n4 = Statistics.pow(n2, n3);
        if (n4 != n) {
            n4 = Statistics.pow(n2, n3 + 1);
        }
        return n4;
    }
}

