/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.GeneralTools;

import jAudioFeatureExtractor.GeneralTools.GeneralMethods;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class StringMethods {
    public static String convertFilePathToFileName(String string) {
        return string.substring(string.lastIndexOf(File.separator) + 1, string.length());
    }

    public static String getDirectoryName(String string) throws Exception {
        int n = string.lastIndexOf(File.separatorChar);
        if (n == -1) {
            throw new Exception(string + " does not contain a valid directory separator.");
        }
        return new String(string.substring(0, string.lastIndexOf(File.separator)) + File.separator);
    }

    public static String removeExtension(String string) {
        if (string.length() < 5) {
            return null;
        }
        if (string.charAt(string.length() - 4) != '.') {
            if (string.charAt(string.length() - 5) == '.') {
                return string.substring(0, string.length() - 5);
            }
            if (string.charAt(string.length() - 3) == '.') {
                return string.substring(0, string.length() - 3);
            }
            return null;
        }
        return string.substring(0, string.length() - 4);
    }

    public static String getExtension(String string) {
        if (string.length() < 5) {
            return null;
        }
        if (string.charAt(string.length() - 4) != '.') {
            if (string.charAt(string.length() - 5) == '.') {
                return string.substring(string.length() - 5, string.length());
            }
            if (string.charAt(string.length() - 3) == '.') {
                return string.substring(string.length() - 3, string.length());
            }
            return null;
        }
        return string.substring(string.length() - 4, string.length());
    }

    public static String getBeginningOfString(String string, int n) {
        String string2 = new String(string);
        if (string.length() < n) {
            int n2 = n - string.length();
            for (int i = 0; i < n2; ++i) {
                string2 = string2 + " ";
            }
            return string2;
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string2;
    }

    public static String getBeginningOfStringWithHyphenFiller(String string, int n) {
        String string2 = new String(string);
        if (string.length() < n) {
            int n2 = n - string.length();
            for (int i = 0; i < n2; ++i) {
                string2 = i == 0 || i == 1 || i == n2 - 2 || i == n2 - 1 ? string2 + " " : string2 + "-";
            }
            return string2;
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string2;
    }

    public static String getDoubleInScientificNotation(double d, int n) {
        if (Double.isNaN(d)) {
            return new String("NaN");
        }
        if (Double.isInfinite(d)) {
            return new String("Infinity");
        }
        String string = "0.";
        for (int i = 0; i < n - 1; ++i) {
            string = string + "#";
        }
        string = string + "E0";
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern(string);
        return decimalFormat.format(d);
    }

    public static String getRoundedDouble(double d, int n) {
        if (d == Double.NaN) {
            return new String("NaN");
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return new String("-Infinity");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return new String("Infinity");
        }
        String string = "#0.";
        for (int i = 0; i < n; ++i) {
            string = string + "#";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    public static int getIndexOfString(String string, String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        throw new Exception("Unable to find " + string + ".");
    }

    public static String[] removeDoubles(String[] stringArray) {
        int n;
        Object[] objectArray = new String[stringArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = stringArray[n];
        }
        for (n = 0; n < objectArray.length - 1; ++n) {
            for (int i = n + 1; i < objectArray.length; ++i) {
                if (objectArray[n] == null || objectArray[i] == null || !((String)objectArray[n]).equals(objectArray[i])) continue;
                objectArray[i] = null;
            }
        }
        Object[] objectArray2 = GeneralMethods.removeNullEntriesFromArray(objectArray);
        String[] stringArray2 = new String[objectArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)objectArray2[i];
        }
        return stringArray2;
    }
}

