/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.AddBatchGUI;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Controller;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class AddBatchAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private JTextArea window_length_text_field;
    private JTextArea window_overlap_fraction_text_field;
    private JCheckBox save_window_features_check_box;
    private JCheckBox save_overall_file_featurese_check_box;
    private JTextArea destinationFV;
    private JTextArea destinationFK;
    private Controller controller;
    private AddBatchGUI addBatchGUI;

    public AddBatchAction(Controller controller) {
        super("Define Batch");
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Batch batch = new Batch();
        boolean bl = true;
        LinkedList<File> linkedList = new LinkedList<File>();
        for (int i = 0; i < this.controller.rtm_.getRowCount(); ++i) {
            linkedList.add(new File((String)this.controller.rtm_.getValueAt(i, 1)));
        }
        File[] fileArray = linkedList.toArray(new File[0]);
        if (fileArray.length == 0) {
            JOptionPane.showMessageDialog(null, "Batches must contain files to record.  Add files to recording table.", "ERROR", 0);
            bl = false;
        }
        try {
            batch.setRecordings(fileArray);
        }
        catch (Exception exception) {
            bl = false;
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
        batch.setDataModel(this.controller.dm_);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (n = 0; n < this.controller.dm_.features.length; ++n) {
            String string = this.controller.dm_.features[n].getFeatureDefinition().name;
            hashMap.put(string, (Boolean)this.controller.fstm_.getValueAt(n, 0));
            int n2 = this.controller.dm_.features[n].getFeatureDefinition().attributes.length;
            for (int i = 0; i < n2; ++i) {
                try {
                    linkedList2.add(this.controller.dm_.features[n].getElement(i));
                    continue;
                }
                catch (Exception exception) {
                    bl = false;
                    JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
                    exception.printStackTrace();
                }
            }
            hashMap2.put(string, linkedList2.toArray(new String[0]));
            linkedList2.clear();
        }
        batch.setFeatures(hashMap, hashMap2);
        n = 512;
        double d = 0.0;
        try {
            n = Integer.parseInt(this.window_length_text_field.getText());
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            JOptionPane.showMessageDialog(null, "window length must be an integer", "ERROR", 0);
        }
        try {
            d = Double.parseDouble(this.window_overlap_fraction_text_field.getText());
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            JOptionPane.showMessageDialog(null, "window overlap must be a double", "ERROR", 0);
        }
        if (d < 0.0 || d >= 1.0) {
            bl = false;
            JOptionPane.showMessageDialog(null, "Window Overlap must be equal or greater than 0 and less than 1.0", "ERROR", 0);
        }
        if (n <= 0) {
            bl = false;
            JOptionPane.showMessageDialog(null, "Window length must be greater than 0", "ERROR", 0);
        }
        Aggregator[] aggregatorArray = this.controller.dm_.aggregators;
        String[] stringArray = new String[aggregatorArray.length];
        String[][] stringArray2 = new String[aggregatorArray.length][];
        String[][] stringArray3 = new String[aggregatorArray.length][];
        for (int i = 0; i < aggregatorArray.length; ++i) {
            stringArray[i] = aggregatorArray[i].getAggregatorDefinition().name;
            stringArray2[i] = aggregatorArray[i].getFeaturesToApply();
            stringArray3[i] = aggregatorArray[i].getParamaters();
        }
        batch.setAggregators(stringArray, stringArray2, stringArray3);
        batch.setSettings(n, d, this.controller.samplingRateAction.getSamplingRate(), this.controller.normalise.isSelected(), this.save_window_features_check_box.isSelected(), this.save_overall_file_featurese_check_box.isSelected(), this.controller.outputTypeAction.getSelected());
        batch.setDestination(this.destinationFK.getText(), this.destinationFV.getText());
        if (bl) {
            this.addBatchGUI = new AddBatchGUI(this.controller, batch);
        } else {
            JOptionPane.showMessageDialog(null, "Batch creation failed", "ERROR", 0);
        }
    }

    public void setSettings(JCheckBox jCheckBox, JCheckBox jCheckBox2, JTextArea jTextArea, JTextArea jTextArea2) {
        this.save_window_features_check_box = jCheckBox;
        this.save_overall_file_featurese_check_box = jCheckBox2;
        this.window_length_text_field = jTextArea;
        this.window_overlap_fraction_text_field = jTextArea2;
    }

    public void setFilePath(JTextArea jTextArea, JTextArea jTextArea2) {
        this.destinationFV = jTextArea;
        this.destinationFK = jTextArea2;
    }
}

