/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class PlayNowAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private Controller controller;
    private JTable recordings_table;

    public PlayNowAction(Controller controller) {
        super("Play From File...");
        this.controller = controller;
    }

    public void setTable(JTable jTable) {
        this.recordings_table = jTable;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.recordings_table.getSelectedRow();
            if (n < 0) {
                throw new Exception("No file selcected for playback.");
            }
            File file = new File(this.controller.dm_.recordingInfo[n].file_path);
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
                audioInputStream = AudioMethods.convertUnsupportedFormat(audioInputStream);
                SourceDataLine sourceDataLine = AudioMethods.getSourceDataLine(audioInputStream.getFormat(), null);
                this.controller.stopPlayBackAction.stopPlayback();
                this.controller.dm_.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audioInputStream, sourceDataLine);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                throw new Exception("File " + file.getName() + " has an unsupported audio format.");
            }
            catch (Exception exception) {
                throw new Exception("File " + file.getName() + " is not playable.\n" + exception.getMessage());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }
}

