/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class PlaySamplesAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private Controller controller;
    private JTable recordings_table;

    public PlaySamplesAction(Controller controller) {
        super("Play Samples...");
        this.controller = controller;
    }

    public void setTable(JTable jTable) {
        this.recordings_table = jTable;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.recordings_table.getSelectedRow();
            if (n < 0) {
                throw new Exception("No file selcected for playback.");
            }
            RecordingInfo recordingInfo = this.controller.dm_.recordingInfo[n];
            try {
                Object object;
                AudioInputStream audioInputStream = null;
                if (recordingInfo.samples != null) {
                    audioInputStream = recordingInfo.samples.getAudioInputStreamChannelSegregated();
                } else {
                    object = new File(recordingInfo.file_path);
                    AudioSamples audioSamples = new AudioSamples((File)object, ((File)object).getPath(), false);
                    if (this.controller.storeSamples.isSelected()) {
                        recordingInfo.samples = audioSamples;
                    }
                    audioInputStream = audioSamples.getAudioInputStreamChannelSegregated();
                }
                object = AudioMethods.getSourceDataLine(audioInputStream.getFormat(), null);
                this.controller.stopPlayBackAction.stopPlayback();
                this.controller.dm_.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audioInputStream, (SourceDataLine)object);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                throw new Exception("File " + recordingInfo.file_path + " has an unsupported audio format.");
            }
            catch (Exception exception) {
                throw new Exception("File " + recordingInfo.file_path + " is not playable.\n" + exception.getMessage());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage(), "ERROR", 0);
        }
    }
}

