/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;

public class AudioMethodsPlayback {
    public static PlayThread playAudioInputStreamInterruptible(AudioInputStream audioInputStream, SourceDataLine sourceDataLine) throws Exception {
        AudioFormat audioFormat;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (!audioFormat2.matches(audioFormat = sourceDataLine.getFormat())) {
            throw new Exception("AudioFormat that audio is presented in differs from AudioFormat that it is to be played in.");
        }
        PlayThread playThread = null;
        playThread = new PlayThread(sourceDataLine, audioInputStream);
        playThread.start();
        return playThread;
    }

    public static void playAudioInputStream(AudioInputStream audioInputStream, SourceDataLine sourceDataLine) throws Exception {
        AudioFormat audioFormat;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (!audioFormat2.matches(audioFormat = sourceDataLine.getFormat())) {
            throw new Exception("AudioFormat that audio is presented in differs from AudioFormat that it is to be played in.");
        }
        PlayThread playThread = new PlayThread(sourceDataLine, audioInputStream);
        playThread.start();
    }

    public static class PlayThread
    extends Thread {
        private byte[] rw_buffer;
        private boolean stop_playing;
        private SourceDataLine source_data_line = null;
        private AudioInputStream audio_input_stream = null;

        PlayThread(SourceDataLine sourceDataLine, AudioInputStream audioInputStream) throws Exception {
            AudioFormat audioFormat = audioInputStream.getFormat();
            AudioFormat audioFormat2 = sourceDataLine.getFormat();
            if (!audioFormat.matches(audioFormat2)) {
                throw new Exception("AudioFormat that audio is presented in differs from AudioFormat that it is to be played in.");
            }
            float f = 0.25f;
            int n = AudioMethods.getNumberBytesNeeded(f, sourceDataLine.getFormat());
            if (sourceDataLine == null) {
                throw new Exception("Target SourceDataLine for playback is empty.");
            }
            if (audioInputStream == null) {
                throw new Exception("Source AudioInputStream for playback is empty.");
            }
            this.source_data_line = sourceDataLine;
            this.audio_input_stream = audioInputStream;
            this.rw_buffer = new byte[n];
            this.stop_playing = false;
        }

        public void run() {
            this.stop_playing = false;
            try {
                int n;
                while ((n = this.audio_input_stream.read(this.rw_buffer, 0, this.rw_buffer.length)) != -1) {
                    if (n > 0) {
                        this.source_data_line.write(this.rw_buffer, 0, n);
                    }
                    if (!this.stop_playing) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                System.exit(0);
            }
            if (!this.stop_playing) {
                this.source_data_line.drain();
            }
            this.source_data_line.close();
        }

        public void stopPlaying() {
            this.stop_playing = true;
        }
    }
}

