/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.dppatheditor;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.TimeInSecForSMF;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.gui.deveditor.view.DeviatedPerformancePlayer;
import jp.crestmuse.cmx.gui.dppatheditor.MainFrame;
import jp.crestmuse.cmx.misc.PerformanceMatcher3;
import org.xml.sax.SAXException;

public class FrameController
implements Runnable {
    private String scoreFilename;
    private String pfmFilename;
    private String devFilename;
    private String cmpFilename;
    private String remadeSMF;
    private PerformanceMatcher3 pm3;
    private int[] score2pfm;
    private DeviationInstanceWrapper dev;
    private DeviatedPerformance deviatedPerformance;
    private DeviatedPerformancePlayer player;
    private MainFrame frame;

    public FrameController(String string, String string2, String string3, String string4, String string5) throws ParserConfigurationException, SAXException, IOException, TransformerException, InvalidMidiDataException {
        this.scoreFilename = string;
        this.pfmFilename = string2;
        this.devFilename = string3;
        this.cmpFilename = string4;
        this.remadeSMF = string5;
        this.pm3 = new PerformanceMatcher3((MusicXMLWrapper)CMXFileWrapper.readfile((String)string), MIDIXMLWrapper.readSMF((String)string2));
        DeviationInstanceWrapper deviationInstanceWrapper = this.pm3.extractDeviation();
        this.score2pfm = (int[])this.pm3.getScore2Pfm().clone();
        deviationInstanceWrapper.finalizeDocument();
        this.deviatedPerformance = new DeviatedPerformance(deviationInstanceWrapper);
        this.player = new DeviatedPerformancePlayer();
        this.player.changeDeviation(this.deviatedPerformance);
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        try {
            this.frame = new MainFrame(this.deviatedPerformance, this.pm3, this.score2pfm, this.player, this);
            this.frame.setDefaultCloseOperation(3);
            this.frame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void reGenerateDeviation() throws ParserConfigurationException, SAXException, IOException, TransformerException, InvalidMidiDataException {
        this.frame.setVisible(false);
        try {
            this.pm3 = new PerformanceMatcher3((MusicXMLWrapper)CMXFileWrapper.readfile((String)this.scoreFilename), MIDIXMLWrapper.readSMF((String)this.pfmFilename));
            this.dev = this.pm3.extractDeviation(this.frame.getScore2pfm());
            this.score2pfm = (int[])this.pm3.getScore2Pfm().clone();
            this.dev.finalizeDocument();
            this.deviatedPerformance = new DeviatedPerformance(this.dev);
        }
        catch (ArithmeticException arithmeticException) {
            JOptionPane.showMessageDialog(this.frame, "invalid matching");
            this.frame.setVisible(true);
            return;
        }
        this.player.changeDeviation(this.deviatedPerformance);
        SwingUtilities.invokeLater(this);
    }

    public void save() throws InvalidFileTypeException, IOException, SAXException, TransformerException, ParserConfigurationException {
        this.dev.writefile(this.devFilename);
        MIDIXMLWrapper mIDIXMLWrapper = this.dev.toSCCXML(1920).toMIDIXML();
        mIDIXMLWrapper.writefileAsSMF(this.remadeSMF);
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.cmpFilename)), true);
        TimeInSecForSMF.changePrintStream((PrintStream)printStream);
        TimeInSecForSMF.main((String[])new String[]{this.pfmFilename, this.remadeSMF});
        printStream.close();
    }
}

