/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.controller;

import java.util.Stack;
import jp.crestmuse.cmx.gui.deveditor.controller.Command;

public class CommandInvoker {
    private Stack<Command> undoStack = new Stack();
    private Stack<Command> redoStack = new Stack();

    public void invoke(Command command) {
        command.invoke();
        this.redoStack.clear();
        this.undoStack.push(command);
    }

    public void undo() {
        if (this.undoStack.isEmpty()) {
            return;
        }
        Command command = this.undoStack.pop();
        command.undo();
        this.redoStack.push(command);
    }

    public void redo() {
        if (this.redoStack.isEmpty()) {
            return;
        }
        Command command = this.redoStack.pop();
        command.redo();
        this.undoStack.push(command);
    }
}

