/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.crestmuse.cmx.filewrappers.CSVWrapper;
import jp.crestmuse.cmx.gui.deveditor.model.Const;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.gui.deveditor.view.CurvesPanel;
import jp.crestmuse.cmx.gui.deveditor.view.DeviatedPerformanceList;
import jp.crestmuse.cmx.gui.deveditor.view.DeviatedPerformancePlayer;
import jp.crestmuse.cmx.gui.deveditor.view.KeyBoardPanel;
import jp.crestmuse.cmx.gui.deveditor.view.PianoRollPanel;
import jp.crestmuse.cmx.gui.deveditor.view.VelocityPanel;
import jp.crestmuse.cmx.sound.MusicPlaySynchronized;
import jp.crestmuse.cmx.sound.MusicPlaySynchronizer;
import org.xml.sax.SAXException;

public class MainFrame
extends JFrame
implements MusicPlaySynchronized {
    private static MainFrame instance;
    private static Dimension PIANO_ROLL_DIM;
    private static Dimension CURVES_VELOCITY_DIM;
    private static Dimension LISTS_DIM;
    private DeviatedPerformancePlayer deviatedPerformancePlayer = new DeviatedPerformancePlayer();
    private MusicPlaySynchronizer synchronizer = new MusicPlaySynchronizer(this.deviatedPerformancePlayer);
    private JMenuItem openMenuItem;
    private DeviatedPerformanceList performances;
    private JScrollPane pianoRollScrollPane;
    private JScrollPane curvesScrollPane;
    private JScrollPane velocityScrollPane;
    private JScrollPane noteListScrollPane;
    private JScrollPane noteEditScrollPane;
    private JSlider currentPositionSlider;
    private JLabel statusLabel;
    private JProgressBar fileLoadingProgressBar;

    public static MainFrame getInstance() {
        return instance;
    }

    private MainFrame() throws MidiUnavailableException {
        this.synchronizer.addSynchronizedComponent(this);
        this.synchronizer.setSleepTime(16L);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.setTitle("DeviationEditor");
                MainFrame.this.setDefaultCloseOperation(3);
                MainFrame.this.setMenuBar();
                JSplitPane jSplitPane = MainFrame.this.setScrollPane();
                JPanel jPanel = MainFrame.this.setEastPanel();
                JPanel jPanel2 = new JPanel(new FlowLayout());
                MainFrame.this.setSlider(jPanel2);
                MainFrame.this.setButtons(jPanel2);
                JPanel jPanel3 = new JPanel(new BorderLayout());
                jPanel3.add((Component)jPanel2, "Center");
                jPanel3.add((Component)MainFrame.this.setStatusBar(), "South");
                JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, jPanel);
                jSplitPane2.setOneTouchExpandable(true);
                MainFrame.this.add((Component)jSplitPane2, "Center");
                MainFrame.this.add((Component)jPanel3, "South");
                MainFrame.this.pack();
                MainFrame.this.setVisible(true);
            }
        });
    }

    private void setMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("file");
        this.openMenuItem = new JMenuItem("open");
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                if (jFileChooser.showOpenDialog(MainFrame.this) == 0) {
                    MainFrame.this.openMenuItem.setEnabled(false);
                    MainFrame.this.open(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JMenuItem jMenuItem = new JMenuItem("save");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                if (jFileChooser.showSaveDialog(MainFrame.this) == 0) {
                    MainFrame.this.save(jFileChooser.getSelectedFile());
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("export");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.performances.isSelectionEmpty()) {
                    return;
                }
                Object[] objectArray = new String[]{"tempo base", "scc base"};
                Object object = JOptionPane.showInputDialog(MainFrame.this, "", "export type", 1, null, objectArray, objectArray[0]);
                if (object == null) {
                    return;
                }
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                if (jFileChooser.showSaveDialog(MainFrame.this) == 0) {
                    DeviatedPerformance deviatedPerformance = MainFrame.this.performances.getSelectedValue().getDeviatedPerformance();
                    CSVWrapper cSVWrapper = object.equals(objectArray[0]) ? deviatedPerformance.toTempoBaseCSV(480) : deviatedPerformance.toSccBaseCSV(480);
                    try {
                        cSVWrapper.writefile(jFileChooser.getSelectedFile());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (SAXException sAXException) {
                        sAXException.printStackTrace();
                    }
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("quit");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(this.openMenuItem);
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        JMenu jMenu2 = new JMenu("show");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("show as real time");
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Const.SHOW_AS_TICK_TIME = !((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("extra");
        jCheckBoxMenuItem2.setSelected(true);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PianoRollPanel.toggleExtra(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                MainFrame.this.repaint();
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("voice1");
        jCheckBoxMenuItem3.setSelected(true);
        jCheckBoxMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PianoRollPanel.toggleVoice1(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                MainFrame.this.repaint();
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem4 = new JCheckBoxMenuItem("voice2");
        jCheckBoxMenuItem4.setSelected(true);
        jCheckBoxMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PianoRollPanel.toggleVoice2(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                MainFrame.this.repaint();
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem5 = new JCheckBoxMenuItem("voice3");
        jCheckBoxMenuItem5.setSelected(true);
        jCheckBoxMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PianoRollPanel.toggleVoice3(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                MainFrame.this.repaint();
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem6 = new JCheckBoxMenuItem("voice4");
        jCheckBoxMenuItem6.setSelected(true);
        jCheckBoxMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PianoRollPanel.toggleVoice4(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                MainFrame.this.repaint();
            }
        });
        JCheckBoxMenuItem jCheckBoxMenuItem7 = new JCheckBoxMenuItem("voice other");
        jCheckBoxMenuItem7.setSelected(true);
        jCheckBoxMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PianoRollPanel.toggleVoiceOther(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                MainFrame.this.repaint();
            }
        });
        jMenu2.add(jCheckBoxMenuItem);
        jMenu2.add(jCheckBoxMenuItem3);
        jMenu2.add(jCheckBoxMenuItem4);
        jMenu2.add(jCheckBoxMenuItem5);
        jMenu2.add(jCheckBoxMenuItem6);
        jMenu2.add(jCheckBoxMenuItem7);
        jMenu2.add(jCheckBoxMenuItem2);
        JMenu jMenu3 = new JMenu("edit");
        JMenuItem jMenuItem4 = new JMenuItem("undo");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.performances.getSelectedValue().getCommandInvoker().undo();
            }
        });
        JMenuItem jMenuItem5 = new JMenuItem("redo");
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.performances.getSelectedValue().getCommandInvoker().redo();
            }
        });
        JMenuItem jMenuItem6 = new JMenuItem("set midi receiver");
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = MainFrame.this.deviatedPerformancePlayer.getReceivers();
                Object object = JOptionPane.showInputDialog(MainFrame.this, "choose midi receiver", "", 1, null, objectArray, objectArray[MainFrame.this.deviatedPerformancePlayer.getCurrentReceiverIndex()]);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (object != objectArray[i]) continue;
                    try {
                        MainFrame.this.deviatedPerformancePlayer.setReciever(i);
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        midiUnavailableException.printStackTrace();
                    }
                    break;
                }
            }
        });
        jMenu3.add(jMenuItem4);
        jMenu3.add(jMenuItem5);
        jMenu3.add(jMenuItem6);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
    }

    private JSplitPane setScrollPane() {
        this.pianoRollScrollPane = new JScrollPane();
        this.curvesScrollPane = new JScrollPane();
        this.velocityScrollPane = new JScrollPane();
        this.pianoRollScrollPane.setPreferredSize(PIANO_ROLL_DIM);
        this.pianoRollScrollPane.getViewport().setScrollMode(0);
        this.pianoRollScrollPane.setRowHeaderView(new KeyBoardPanel());
        this.pianoRollScrollPane.setCorner("UPPER_LEFT_CORNER", new JPanel());
        this.pianoRollScrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        this.pianoRollScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        this.pianoRollScrollPane.setVerticalScrollBarPolicy(22);
        this.curvesScrollPane.setPreferredSize(CURVES_VELOCITY_DIM);
        this.curvesScrollPane.setRowHeaderView(new CurvesPanel.RowHeader());
        this.curvesScrollPane.setVerticalScrollBarPolicy(22);
        JScrollBar jScrollBar = this.pianoRollScrollPane.getHorizontalScrollBar();
        this.curvesScrollPane.setHorizontalScrollBar(jScrollBar);
        this.velocityScrollPane.setPreferredSize(CURVES_VELOCITY_DIM);
        this.velocityScrollPane.setCorner("LOWER_LEFT_CORNER", new JPanel());
        this.velocityScrollPane.setRowHeaderView(new VelocityPanel.RowHeader());
        this.velocityScrollPane.setVerticalScrollBarPolicy(22);
        this.velocityScrollPane.setHorizontalScrollBar(jScrollBar);
        JSplitPane jSplitPane = new JSplitPane(0, this.curvesScrollPane, this.velocityScrollPane);
        jSplitPane.setOneTouchExpandable(true);
        JSplitPane jSplitPane2 = new JSplitPane(0, this.pianoRollScrollPane, jSplitPane);
        jSplitPane2.setOneTouchExpandable(true);
        return jSplitPane2;
    }

    private JPanel setEastPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        this.performances = new DeviatedPerformanceList();
        this.performances.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MainFrame.this.setPerformanceAsSelectedValue();
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(LISTS_DIM);
        jScrollPane.setViewportView(this.performances);
        jPanel.add(jScrollPane);
        this.noteListScrollPane = new JScrollPane();
        jPanel.add(this.noteListScrollPane);
        this.noteEditScrollPane = new JScrollPane();
        jPanel.add(this.noteEditScrollPane);
        return jPanel;
    }

    private void setPerformanceAsSelectedValue() {
        DeviatedPerformanceList.ListElement listElement = this.performances.getSelectedValue();
        if (listElement.isLoading()) {
            return;
        }
        try {
            this.deviatedPerformancePlayer.changeDeviation(listElement.getDeviatedPerformance());
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
        this.pianoRollScrollPane.setViewportView(listElement.getPianoRollPanel());
        this.curvesScrollPane.setViewportView(listElement.getCurvesPanel());
        this.velocityScrollPane.setViewportView(listElement.getVelocityPanel());
        this.noteListScrollPane.setViewportView(listElement.getNoteList());
        this.noteEditScrollPane.setViewportView(listElement.getNoteEditPanel());
        Point point = this.pianoRollScrollPane.getViewport().getViewPosition();
        point.y = (PianoRollPanel.HEIGHT_PER_NOTE * 128 - this.pianoRollScrollPane.getHeight()) / 2;
        this.pianoRollScrollPane.getViewport().setViewPosition(point);
        if (!Const.SHOW_AS_TICK_TIME) {
            this.currentPositionSlider.setMaximum((int)this.deviatedPerformancePlayer.getCurrentSequence().getMicrosecondLength());
        } else {
            this.currentPositionSlider.setMaximum((int)this.deviatedPerformancePlayer.getCurrentSequence().getTickLength());
        }
        this.setTitle(listElement.getName() + " - DeviationEditor");
    }

    private void setSlider(JPanel jPanel) {
        this.currentPositionSlider = new JSlider();
        this.currentPositionSlider.setValue(0);
        this.currentPositionSlider.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (MainFrame.this.performances.isSelectionEmpty()) {
                    return;
                }
                MainFrame.this.setPlayPosition(MainFrame.this.currentPositionSlider.getValue());
            }
        });
        jPanel.add(this.currentPositionSlider);
    }

    private void setButtons(JPanel jPanel) {
        JButton jButton = new JButton("start");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (MainFrame.this.synchronizer.isNowPlaying()) {
                    MainFrame.this.currentPositionSlider.setEnabled(true);
                    MainFrame.this.synchronizer.stop();
                    jButton.setText("start");
                } else {
                    MainFrame.this.currentPositionSlider.setEnabled(false);
                    MainFrame.this.synchronizer.play();
                    jButton.setText("pause");
                }
            }
        });
        JButton jButton2 = new JButton("reset");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.currentPositionSlider.setEnabled(true);
                MainFrame.this.synchronizer.stop();
                MainFrame.this.setPlayPosition(0L);
            }
        });
        JButton jButton3 = new JButton("change");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Const.SHOW_AS_TICK_TIME) {
                    MainFrame.this.currentPositionSlider.setMaximum((int)MainFrame.this.deviatedPerformancePlayer.getCurrentSequence().getTickLength());
                    MainFrame.this.currentPositionSlider.setValue((int)MainFrame.this.deviatedPerformancePlayer.getTickPosition());
                } else {
                    MainFrame.this.currentPositionSlider.setMaximum((int)MainFrame.this.deviatedPerformancePlayer.getCurrentSequence().getMicrosecondLength());
                    MainFrame.this.currentPositionSlider.setValue((int)MainFrame.this.deviatedPerformancePlayer.getMicrosecondPosition());
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
    }

    private JPanel setStatusBar() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel();
        this.fileLoadingProgressBar = new JProgressBar();
        jPanel.add((Component)this.statusLabel, "West");
        jPanel.add((Component)this.fileLoadingProgressBar, "East");
        return jPanel;
    }

    @Override
    public void start(MusicPlaySynchronizer musicPlaySynchronizer) {
    }

    @Override
    public void stop(MusicPlaySynchronizer musicPlaySynchronizer) {
        this.deviatedPerformancePlayer.reset();
        this.currentPositionSlider.setEnabled(true);
    }

    @Override
    public void synchronize(final double d, final long l, MusicPlaySynchronizer musicPlaySynchronizer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PianoRollPanel pianoRollPanel = MainFrame.this.performances.getSelectedValue().getPianoRollPanel();
                Point point = MainFrame.this.pianoRollScrollPane.getViewport().getViewPosition();
                point.x = pianoRollPanel.getPlayPointX(d, l);
                int n = MainFrame.this.pianoRollScrollPane.getViewport().getWidth();
                point.x = Math.max(0, Math.min(pianoRollPanel.getPreferredSize().width - n, point.x - n / 2));
                MainFrame.this.pianoRollScrollPane.getViewport().setViewPosition(point);
                if (point.x <= 0 || point.x >= n - MainFrame.this.pianoRollScrollPane.getViewport().getWidth()) {
                    pianoRollPanel.repaint();
                }
                if (!Const.SHOW_AS_TICK_TIME) {
                    MainFrame.this.currentPositionSlider.setValue((int)(d * 1000000.0));
                } else {
                    MainFrame.this.currentPositionSlider.setValue((int)l);
                }
            }
        });
    }

    public void open(String string) {
        this.statusLabel.setText("loading...");
        this.fileLoadingProgressBar.setIndeterminate(true);
        this.performances.addPerformance(string, this.noteListScrollPane, new DeviatedPerformanceList.ListElementLoadListener(){

            @Override
            public void listElementLoaded() {
                if (MainFrame.this.performances.isSelectionEmpty()) {
                    MainFrame.this.performances.setSelectedIndex(0);
                    MainFrame.this.setPerformanceAsSelectedValue();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.openMenuItem.setEnabled(true);
                    }
                });
                MainFrame.this.statusLabel.setText("");
                MainFrame.this.fileLoadingProgressBar.setIndeterminate(false);
                MainFrame.this.repaint();
            }

            @Override
            public void listElementLoadFailed() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.openMenuItem.setEnabled(true);
                    }
                });
                MainFrame.this.statusLabel.setText("");
                MainFrame.this.fileLoadingProgressBar.setIndeterminate(false);
                MainFrame.this.repaint();
            }
        });
    }

    public void save(final File file) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    MainFrame.this.deviatedPerformancePlayer.writeFile(new FileOutputStream(file));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public void setPlayPosition(long l) {
        if (Const.SHOW_AS_TICK_TIME) {
            this.deviatedPerformancePlayer.setTickPosition(l);
        } else {
            this.deviatedPerformancePlayer.setMicrosecondPosition(l);
        }
        this.synchronize((double)this.deviatedPerformancePlayer.getMicrosecondPosition() / 1000000.0, this.deviatedPerformancePlayer.getTickPosition(), null);
    }

    static {
        try {
            instance = new MainFrame();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        PIANO_ROLL_DIM = new Dimension(640, 320);
        CURVES_VELOCITY_DIM = new Dimension(640, 100);
        LISTS_DIM = new Dimension(240, 1);
    }
}

