/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.crestmuse.cmx.gui.deveditor.controller.ChangeDeviation;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteControler;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteSelectListener;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteUpdateListener;
import jp.crestmuse.cmx.gui.deveditor.controller.SetMissNote;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;

public class NoteEditPanel
extends JPanel
implements DeviatedNoteSelectListener,
DeviatedNoteUpdateListener {
    private DeviatedPerformance.DeviatedNote deviatedNote;
    private DeviatedNoteControler deviatedNoteControler;
    private JSpinner attackSpinner;
    private JSpinner releaseSpinner;
    private JSpinner dynamicsSpinner;
    private JSpinner endDynamicsSpinner;
    private JCheckBox missnote;
    private double prevAttack;
    private double prevRelease;
    private boolean changeByOther = false;

    public NoteEditPanel(DeviatedNoteControler deviatedNoteControler) {
        this.deviatedNoteControler = deviatedNoteControler;
        this.prevRelease = 0.0;
        this.prevAttack = 0.0;
        deviatedNoteControler.addDeviatedNoteSelectListener(this);
        this.setAttack();
        this.setRelease();
        this.setDynamics();
        this.setEndDynamics();
        this.setIsMissNote();
        JButton jButton = new JButton("reset");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NoteEditPanel.this.deviatedNoteControler.update(new ChangeDeviation(NoteEditPanel.this.deviatedNote, 0.0, 0.0, 1.0, 1.0));
                NoteEditPanel.this.deviatedNoteControler.update(new SetMissNote(NoteEditPanel.this.deviatedNote, false));
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.add(new JLabel("attack"));
        jPanel.add(this.attackSpinner);
        jPanel.add(new JLabel("release"));
        jPanel.add(this.releaseSpinner);
        jPanel.add(new JLabel("dynamics"));
        jPanel.add(this.dynamicsSpinner);
        jPanel.add(new JLabel("endDynamincs"));
        jPanel.add(this.endDynamicsSpinner);
        jPanel.add(this.missnote);
        jPanel.add(jButton);
        this.add(jPanel);
    }

    private void setAttack() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue(0.0);
        spinnerNumberModel.setStepSize(0.1);
        this.attackSpinner = new JSpinner(spinnerNumberModel);
        this.attackSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NoteEditPanel.this.attackSpinner.getValue();
                if (NoteEditPanel.this.changeByOther) {
                    return;
                }
                NoteEditPanel.this.deviatedNoteControler.update(new ChangeDeviation(NoteEditPanel.this.deviatedNote, d - NoteEditPanel.this.prevAttack, 0.0));
                NoteEditPanel.this.prevAttack = d;
            }
        });
    }

    private void setRelease() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue(0.0);
        spinnerNumberModel.setStepSize(0.1);
        this.releaseSpinner = new JSpinner(spinnerNumberModel);
        this.releaseSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NoteEditPanel.this.releaseSpinner.getValue();
                if (NoteEditPanel.this.changeByOther) {
                    return;
                }
                NoteEditPanel.this.deviatedNoteControler.update(new ChangeDeviation(NoteEditPanel.this.deviatedNote, 0.0, d - NoteEditPanel.this.prevRelease));
                NoteEditPanel.this.prevRelease = d;
            }
        });
    }

    private void setDynamics() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setMinimum(Double.valueOf(0.0));
        spinnerNumberModel.setValue(0.0);
        spinnerNumberModel.setStepSize(0.1);
        spinnerNumberModel.setMaximum(Double.valueOf(1.0));
        this.dynamicsSpinner = new JSpinner(spinnerNumberModel);
        this.dynamicsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NoteEditPanel.this.dynamicsSpinner.getValue();
                if (NoteEditPanel.this.changeByOther) {
                    return;
                }
                NoteEditPanel.this.deviatedNoteControler.update(new ChangeDeviation(NoteEditPanel.this.deviatedNote, 0.0, 0.0, d, NoteEditPanel.this.deviatedNote.getEndDynamics()));
            }
        });
    }

    private void setEndDynamics() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setMinimum(Double.valueOf(0.0));
        spinnerNumberModel.setValue(0.0);
        spinnerNumberModel.setStepSize(0.1);
        spinnerNumberModel.setMaximum(Double.valueOf(1.0));
        this.endDynamicsSpinner = new JSpinner(spinnerNumberModel);
        this.endDynamicsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)NoteEditPanel.this.endDynamicsSpinner.getValue();
                if (NoteEditPanel.this.changeByOther) {
                    return;
                }
                NoteEditPanel.this.deviatedNoteControler.update(new ChangeDeviation(NoteEditPanel.this.deviatedNote, 0.0, 0.0, NoteEditPanel.this.deviatedNote.getDynamics(), d));
            }
        });
    }

    private void setIsMissNote() {
        this.missnote = new JCheckBox("missnote");
        this.missnote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NoteEditPanel.this.changeByOther) {
                    return;
                }
                NoteEditPanel.this.deviatedNoteControler.update(new SetMissNote(NoteEditPanel.this.deviatedNote, NoteEditPanel.this.missnote.isSelected()));
            }
        });
    }

    private void setNote(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.deviatedNote = deviatedNote;
        this.prevAttack = deviatedNote.getAttack();
        this.prevRelease = deviatedNote.getRelease();
        this.attackSpinner.setValue(this.prevAttack);
        this.releaseSpinner.setValue(this.prevRelease);
        this.dynamicsSpinner.setValue(deviatedNote.getDynamics());
        this.endDynamicsSpinner.setValue(deviatedNote.getEndDynamics());
        this.missnote.setSelected(deviatedNote.getIsMissNote());
    }

    @Override
    public void noteSelected(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.changeByOther = true;
        this.setNote(deviatedNote);
        this.changeByOther = false;
    }

    @Override
    public void noteUpdated(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.changeByOther = true;
        this.setNote(deviatedNote);
        this.changeByOther = false;
    }
}

