/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteControler;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteSelectListener;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteUpdateListener;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;

public class NoteList
extends JList
implements MouseListener,
DeviatedNoteSelectListener,
DeviatedNoteUpdateListener {
    private HashMap<DeviatedPerformance.DeviatedNote, Integer> dn2index;
    private JScrollPane parent;
    private DeviatedNoteControler deviatedNoteControler;
    private DefaultListModel model;
    private boolean selectByList = false;

    public NoteList(DeviatedPerformance deviatedPerformance, DeviatedNoteControler deviatedNoteControler, JScrollPane jScrollPane) {
        deviatedNoteControler.addDeviatedNoteSelectListener(this);
        this.addMouseListener(this);
        this.deviatedNoteControler = deviatedNoteControler;
        this.parent = jScrollPane;
        this.model = new DefaultListModel();
        this.setModel(this.model);
        this.dn2index = new HashMap();
        for (DeviatedPerformance.DeviatedNote deviatedNote : deviatedPerformance.getDeviatedNotes()) {
            this.dn2index.put(deviatedNote, this.model.getSize());
            this.model.addElement(new ListElement(deviatedNote));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.selectByList = true;
        int n = this.locationToIndex(mouseEvent.getPoint());
        ListElement listElement = (ListElement)this.model.get(n);
        this.deviatedNoteControler.select(listElement.dn);
        this.selectByList = false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void noteSelected(DeviatedPerformance.DeviatedNote deviatedNote) {
        if (this.selectByList) {
            return;
        }
        this.setSelectedIndex(this.dn2index.get(deviatedNote));
        this.parent.getViewport().setViewPosition(this.indexToLocation(this.getSelectedIndex()));
    }

    @Override
    public void noteUpdated(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.repaint();
    }

    private class ListElement {
        DeviatedPerformance.DeviatedNote dn;

        ListElement(DeviatedPerformance.DeviatedNote deviatedNote) {
            this.dn = deviatedNote;
        }

        public String toString() {
            return this.dn.onset() + ", " + this.dn.offset() + ", " + this.dn.notenum();
        }
    }
}

