/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteSelectListener;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteUpdateListener;
import jp.crestmuse.cmx.gui.deveditor.model.Const;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;

public class PianoRollPanel
extends JPanel
implements DeviatedNoteSelectListener,
DeviatedNoteUpdateListener {
    public static int WIDTH_PER_BEAT = 32;
    public static int HEIGHT_PER_NOTE = 16;
    public static int COLUMN_HEADER_HEIGHT = 16;
    private DeviatedPerformance deviatedPerformance;
    private ArrayList<PrintableOriginalNote> originalNotes;
    private ArrayList<PrintableDeviatedNote> deviatedNotes;
    private ArrayList<PrintableNote> allNotes;
    private PrintableDeviatedNote hoverNote;
    private PrintableDeviatedNote selectedNote;
    private ColumnHeaderPanel columnHeader;
    private int playingLine;
    private HashMap<DeviatedPerformance.DeviatedNote, PrintableDeviatedNote> dn2pdn;
    private boolean hideDeviatedNote = false;
    private static short showVoice = (short)63;

    public PianoRollPanel(DeviatedPerformance deviatedPerformance) {
        this.deviatedPerformance = deviatedPerformance;
        this.playingLine = 0;
        this.originalNotes = new ArrayList();
        this.deviatedNotes = new ArrayList();
        this.allNotes = new ArrayList();
        this.dn2pdn = new HashMap();
        for (DeviatedPerformance.DeviatedNote deviatedNote : deviatedPerformance.getDeviatedNotes()) {
            PrintableDeviatedNote printableDeviatedNote = new PrintableDeviatedNote(deviatedNote);
            this.deviatedNotes.add(printableDeviatedNote);
            this.allNotes.add(printableDeviatedNote);
            this.dn2pdn.put(deviatedNote, printableDeviatedNote);
            if (deviatedNote.isExtraNote()) continue;
            PrintableOriginalNote printableOriginalNote = new PrintableOriginalNote(deviatedNote);
            this.originalNotes.add(printableOriginalNote);
            this.allNotes.add(printableOriginalNote);
            printableDeviatedNote.pair = printableOriginalNote;
            printableOriginalNote.pair = printableDeviatedNote;
        }
        int n = (int)deviatedPerformance.getSequence().getTickLength();
        int n2 = WIDTH_PER_BEAT * n / DeviatedPerformance.TICKS_PER_BEAT;
        this.setPreferredSize(new Dimension(n2, HEIGHT_PER_NOTE * 128));
        int n3 = n / (DeviatedPerformance.TICKS_PER_BEAT * 4);
        int n4 = (int)(deviatedPerformance.getSequence().getMicrosecondLength() / 1000000L);
        this.columnHeader = new ColumnHeaderPanel(n3, WIDTH_PER_BEAT * 4, n4, n2 / n4, n2, COLUMN_HEADER_HEIGHT);
    }

    @Override
    public void noteSelected(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.selectedNote = this.dn2pdn.get(deviatedNote);
        this.hoverNote = null;
        this.repaint();
    }

    @Override
    public void noteUpdated(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.dn2pdn.get(deviatedNote).updateScale();
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        graphics.setColor(Color.BLACK);
        if (!Const.SHOW_AS_TICK_TIME) {
            int n2 = 2 * this.getPreferredSize().width / (int)(this.deviatedPerformance.getSequence().getMicrosecondLength() / 1000000L);
            for (n = 0; n < this.getPreferredSize().width; n += n2) {
                graphics.drawLine(n, 0, n, this.getHeight());
            }
        } else {
            MusicXMLWrapper musicXMLWrapper = this.deviatedPerformance.getMusicXML();
            for (n = 1; n < musicXMLWrapper.getPartList()[0].getMeasureList().length; ++n) {
                int n3 = musicXMLWrapper.getCumulativeTicks(n, DeviatedPerformance.TICKS_PER_BEAT);
                n3 = n3 * WIDTH_PER_BEAT / DeviatedPerformance.TICKS_PER_BEAT;
                graphics.drawLine(n3, 0, n3, this.getHeight());
            }
        }
        for (PrintableNote printableNote : this.allNotes) {
            printableNote.paint(graphics);
        }
        if (this.hoverNote != null) {
            this.hoverNote.paintAsHover(graphics);
        }
        if (this.selectedNote != null) {
            if (this.hideDeviatedNote) {
                if (this.selectedNote.pair != null) {
                    this.selectedNote.pair.paintAsSelected(graphics);
                }
            } else {
                this.selectedNote.paintAsSelected(graphics);
            }
        }
        graphics.setColor(Color.BLUE);
        graphics.fillRect(this.playingLine - 1, 0, 3, this.getHeight());
    }

    public DeviatedPerformance getDeviatedPerformance() {
        return this.deviatedPerformance;
    }

    public ColumnHeaderPanel getColumnHeader() {
        return this.columnHeader;
    }

    public int getPlayPointX(double d, long l) {
        this.playingLine = Const.SHOW_AS_TICK_TIME ? (int)((long)this.getPreferredSize().width * l / this.deviatedPerformance.getSequence().getTickLength()) : (int)((double)this.getPreferredSize().width * d * 1000000.0 / (double)this.deviatedPerformance.getSequence().getMicrosecondLength());
        return this.playingLine;
    }

    public void updateScale() {
        int n = (int)this.deviatedPerformance.getSequence().getTickLength();
        int n2 = WIDTH_PER_BEAT * n / DeviatedPerformance.TICKS_PER_BEAT;
        this.setPreferredSize(new Dimension(n2, HEIGHT_PER_NOTE * 128));
        for (PrintableNote printableNote : this.allNotes) {
            printableNote.updateScale();
        }
        this.columnHeader.setPreferredSize(new Dimension(n2, COLUMN_HEADER_HEIGHT));
        this.columnHeader.widthPerMeasure = PianoRollPanel.WIDTH_PER_BEAT * 4;
        int n3 = (int)(this.deviatedPerformance.getSequence().getMicrosecondLength() / 1000000L);
        this.columnHeader.widthPerSecond = n2 / n3;
    }

    public boolean isShowing(DeviatedPerformance.DeviatedNote deviatedNote) {
        return (this.dn2pdn.get(deviatedNote).voice & showVoice) > 0;
    }

    public boolean existHoverNote() {
        return this.hoverNote != null;
    }

    public PrintableDeviatedNote getHoverNote() {
        return this.hoverNote;
    }

    public void setHoverNote(PrintableDeviatedNote printableDeviatedNote) {
        this.hoverNote = printableDeviatedNote;
    }

    public void releaseHoverNote() {
        this.hoverNote = null;
    }

    public PrintableDeviatedNote getSelectedNote() {
        return this.selectedNote;
    }

    public Color getNoteColor(DeviatedPerformance.DeviatedNote deviatedNote) {
        return this.dn2pdn.get(deviatedNote).roundColor;
    }

    public ArrayList<PrintableOriginalNote> getOriginalNotes() {
        return this.originalNotes;
    }

    public ArrayList<PrintableDeviatedNote> getDeviatedNotes() {
        return this.deviatedNotes;
    }

    public void setHideDeviateNote(boolean bl) {
        this.hideDeviatedNote = bl;
    }

    public boolean getHideDeviatedNote() {
        return this.hideDeviatedNote;
    }

    public PrintableDeviatedNote getPrintableDeviatedNote(DeviatedPerformance.DeviatedNote deviatedNote) {
        return this.dn2pdn.get(deviatedNote);
    }

    public static void toggleExtra(boolean bl) {
        showVoice = bl ? (short)(showVoice | 1) : (short)(showVoice & 0x3E);
    }

    public static void toggleVoice1(boolean bl) {
        showVoice = bl ? (short)(showVoice | 2) : (short)(showVoice & 0x3D);
    }

    public static void toggleVoice2(boolean bl) {
        showVoice = bl ? (short)(showVoice | 4) : (short)(showVoice & 0x3B);
    }

    public static void toggleVoice3(boolean bl) {
        showVoice = bl ? (short)(showVoice | 8) : (short)(showVoice & 0x37);
    }

    public static void toggleVoice4(boolean bl) {
        showVoice = bl ? (short)(showVoice | 0x10) : (short)(showVoice & 0x2F);
    }

    public static void toggleVoiceOther(boolean bl) {
        showVoice = bl ? (short)(showVoice | 0x20) : (short)(showVoice & 0x1F);
    }

    private class ColumnHeaderPanel
    extends JPanel {
        private int measureNum;
        private int widthPerMeasure;
        private int seconds;
        private int widthPerSecond;

        public ColumnHeaderPanel(int n, int n2, int n3, int n4, int n5, int n6) {
            this.measureNum = n;
            this.widthPerMeasure = n2;
            this.seconds = n3;
            this.widthPerSecond = n4;
            this.setPreferredSize(new Dimension(n5, n6));
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.BLACK);
            if (Const.SHOW_AS_TICK_TIME) {
                for (int i = 0; i < this.measureNum; ++i) {
                    graphics.drawString(i + 1 + "", i * this.widthPerMeasure, COLUMN_HEADER_HEIGHT);
                }
            } else {
                for (int i = 0; i < this.seconds; i += 2) {
                    graphics.drawString(i / 60 + ":" + i % 60, i * this.widthPerSecond, COLUMN_HEADER_HEIGHT);
                }
            }
        }
    }

    public class PrintableDeviatedNote
    extends PrintableNote {
        private PrintableOriginalNote pair;
        private DeviatedPerformance.DeviatedNote deviatedNote;
        private Color fillColor;
        private Color roundColor;
        private short voice;

        private PrintableDeviatedNote(DeviatedPerformance.DeviatedNote deviatedNote) {
            this.deviatedNote = deviatedNote;
            this.updateScale();
            this.y = HEIGHT_PER_NOTE * (127 - deviatedNote.notenum());
            this.height = HEIGHT_PER_NOTE;
        }

        @Override
        void paint(Graphics graphics) {
            if ((showVoice & this.voice) > 0 && !PianoRollPanel.this.hideDeviatedNote) {
                graphics.setColor(this.fillColor);
                graphics.fillRect(this.x, this.y, this.width, this.height);
                graphics.setColor(this.roundColor);
                graphics.drawRect(this.x + 1, this.y + 1, this.width - 3, this.height - 3);
            }
        }

        private void paintAsHover(Graphics graphics) {
            graphics.setColor(this.roundColor);
            graphics.fillRect(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }

        private void paintAsSelected(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < 3; ++i) {
                graphics.drawRect(this.x - i, this.y - i, this.width + i * 2, this.height + i * 2);
            }
        }

        @Override
        void updateScale() {
            if (Const.SHOW_AS_TICK_TIME) {
                int n = DeviatedPerformance.TICKS_PER_BEAT;
                this.x = this.deviatedNote.onset() * WIDTH_PER_BEAT / n;
                this.width = (this.deviatedNote.offset() - this.deviatedNote.onset()) * WIDTH_PER_BEAT / n;
            } else {
                int n = PianoRollPanel.this.getPreferredSize().width;
                int n2 = (int)(PianoRollPanel.this.getDeviatedPerformance().getSequence().getMicrosecondLength() / 1000L);
                this.x = n * this.deviatedNote.onsetInMSec() / n2;
                this.width = n * (this.deviatedNote.offsetInMSec() - this.deviatedNote.onsetInMSec()) / n2;
            }
            if (this.deviatedNote.isExtraNote()) {
                this.voice = 1;
                this.fillColor = new Color(255, 255, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.YELLOW;
            } else if (this.deviatedNote.getNote().voice() == 1) {
                this.voice = (short)2;
                this.fillColor = new Color(255, 0, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.RED;
            } else if (this.deviatedNote.getNote().voice() == 2) {
                this.voice = (short)4;
                this.fillColor = new Color(255, 127, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.ORANGE;
            } else if (this.deviatedNote.getNote().voice() == 3) {
                this.voice = (short)8;
                this.fillColor = new Color(255, 175, 175, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.PINK;
            } else if (this.deviatedNote.getNote().voice() == 4) {
                this.voice = (short)16;
                this.fillColor = new Color(255, 0, 255, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.MAGENTA;
            } else {
                this.voice = (short)32;
                this.fillColor = new Color(255, 0, 127, this.deviatedNote.velocity() * 2);
                this.roundColor = new Color(255, 0, 127);
            }
        }

        public boolean isMouseOnRight(int n, int n2) {
            return this.isMouseOver(n, n2) && n > this.x + this.width / 2;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int n) {
            this.x = n;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getHeight() {
            return this.height;
        }

        public DeviatedPerformance.DeviatedNote getDeviatedNote() {
            return this.deviatedNote;
        }

        public boolean show() {
            return (this.voice & showVoice) > 0;
        }
    }

    public class PrintableOriginalNote
    extends PrintableNote {
        private int onset;
        private int offset;
        private int onsetInMSec;
        private int offsetInMSec;
        private PrintableDeviatedNote pair;

        public PrintableOriginalNote(DeviatedPerformance.DeviatedNote deviatedNote) {
            this.onset = deviatedNote.onsetOriginal();
            this.offset = deviatedNote.offsetOriginal();
            this.onsetInMSec = deviatedNote.onsetOriginalInMSec();
            this.offsetInMSec = deviatedNote.offsetOriginalInMSec();
            this.y = HEIGHT_PER_NOTE * (127 - deviatedNote.notenum());
            this.height = HEIGHT_PER_NOTE;
            this.updateScale();
        }

        public PrintableDeviatedNote getPair() {
            return this.pair;
        }

        @Override
        void paint(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(this.x, this.y, this.width - 1, this.height - 1);
        }

        void paintAsSelected(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(this.x, this.y, this.width - 1, this.height - 1);
        }

        @Override
        void updateScale() {
            if (Const.SHOW_AS_TICK_TIME) {
                int n = DeviatedPerformance.TICKS_PER_BEAT;
                this.x = this.onset * WIDTH_PER_BEAT / n;
                this.width = (this.offset - this.onset) * WIDTH_PER_BEAT / n;
            } else {
                int n = PianoRollPanel.this.getPreferredSize().width;
                int n2 = (int)(PianoRollPanel.this.getDeviatedPerformance().getSequence().getMicrosecondLength() / 1000L);
                this.x = n * this.onsetInMSec / n2;
                this.width = n * (this.offsetInMSec - this.onsetInMSec) / n2;
            }
        }
    }

    private abstract class PrintableNote {
        int x;
        int y;
        int width;
        int height;

        private PrintableNote() {
        }

        public boolean isMouseOver(int n, int n2) {
            return n > this.x && n < this.x + this.width && n2 > this.y && n2 < this.y + this.height;
        }

        abstract void updateScale();

        abstract void paint(Graphics var1);
    }
}

