/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.crestmuse.cmx.gui.deveditor.controller.ChangeDeviation;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteControler;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteSelectListener;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteUpdateListener;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.gui.deveditor.view.CurvesPanel;
import jp.crestmuse.cmx.gui.deveditor.view.PianoRollPanel;

public class VelocityPanel
extends JPanel
implements ChangeListener,
DeviatedNoteSelectListener,
DeviatedNoteUpdateListener,
MouseListener,
MouseMotionListener {
    public static int PANEL_HEIGTH = 100;
    private PianoRollPanel pianoRollPanel;
    private ArrayList<NoteVelocity> velocities;
    private HashMap<DeviatedPerformance.DeviatedNote, NoteVelocity> dn2nv;
    private NoteVelocity selectedNoteVelocity;
    private DeviatedNoteControler deviatedNoteControler;
    private boolean dragged = false;

    public VelocityPanel(DeviatedPerformance deviatedPerformance, PianoRollPanel pianoRollPanel, DeviatedNoteControler deviatedNoteControler) {
        this.pianoRollPanel = pianoRollPanel;
        this.deviatedNoteControler = deviatedNoteControler;
        this.deviatedNoteControler.addDeviatedNoteSelectListener(this);
        this.velocities = new ArrayList();
        this.dn2nv = new HashMap();
        for (DeviatedPerformance.DeviatedNote deviatedNote : deviatedPerformance.getDeviatedNotes()) {
            NoteVelocity noteVelocity = new NoteVelocity(deviatedNote);
            this.velocities.add(noteVelocity);
            this.dn2nv.put(deviatedNote, noteVelocity);
        }
        this.updateScale();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void updateScale() {
        int n = this.pianoRollPanel.getPreferredSize().width;
        this.setPreferredSize(new Dimension(n, PANEL_HEIGTH));
        for (NoteVelocity noteVelocity : this.velocities) {
            noteVelocity.updateScale();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateScale();
        this.repaint();
    }

    @Override
    public void noteSelected(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.selectedNoteVelocity = this.dn2nv.get(deviatedNote);
        this.repaint();
    }

    @Override
    public void noteUpdated(DeviatedPerformance.DeviatedNote deviatedNote) {
        this.dn2nv.get(deviatedNote).updateScale();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        for (NoteVelocity noteVelocity : this.velocities) {
            if (noteVelocity.x1 > mouseEvent.getX() || noteVelocity.x2 < mouseEvent.getX() || this.getHeight() - noteVelocity.y > mouseEvent.getY() || !this.pianoRollPanel.isShowing(noteVelocity.deviatedNote)) continue;
            this.deviatedNoteControler.select(noteVelocity.deviatedNote);
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.selectedNoteVelocity != null && this.dragged) {
            this.dragged = false;
            DeviatedPerformance.DeviatedNote deviatedNote = this.selectedNoteVelocity.deviatedNote;
            double d = deviatedNote.velocity2dynamics(this.selectedNoteVelocity.y);
            ChangeDeviation changeDeviation = new ChangeDeviation(deviatedNote, 0.0, 0.0, d, d);
            this.deviatedNoteControler.update(changeDeviation);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedNoteVelocity != null) {
            this.selectedNoteVelocity.y = Math.min(this.getHeight() - mouseEvent.getY(), 127);
            this.selectedNoteVelocity.velocity = this.selectedNoteVelocity.y + "";
            this.dragged = true;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (NoteVelocity noteVelocity : this.velocities) {
            noteVelocity.paint(graphics);
        }
        if (this.selectedNoteVelocity != null) {
            this.selectedNoteVelocity.paintAsSelected(graphics);
        }
    }

    public static class RowHeader
    extends JPanel {
        public RowHeader() {
            this.setPreferredSize(new Dimension(CurvesPanel.ROW_HEADER_WIDTH, 1));
            this.add(new JLabel("velocity"));
        }
    }

    private class NoteVelocity {
        DeviatedPerformance.DeviatedNote deviatedNote;
        int x1;
        int x2;
        int y;
        String velocity;
        Color color;

        NoteVelocity(DeviatedPerformance.DeviatedNote deviatedNote) {
            this.deviatedNote = deviatedNote;
            this.color = VelocityPanel.this.pianoRollPanel.getNoteColor(deviatedNote);
            this.updateScale();
        }

        void updateScale() {
            this.x1 = this.deviatedNote.onset() * PianoRollPanel.WIDTH_PER_BEAT / DeviatedPerformance.TICKS_PER_BEAT;
            this.x2 = this.deviatedNote.offset() * PianoRollPanel.WIDTH_PER_BEAT / DeviatedPerformance.TICKS_PER_BEAT;
            this.y = this.deviatedNote.velocity();
            this.velocity = this.deviatedNote.velocity() + "";
        }

        void paint(Graphics graphics) {
            if (!VelocityPanel.this.pianoRollPanel.isShowing(this.deviatedNote)) {
                return;
            }
            graphics.setColor(this.color);
            graphics.drawLine(this.x1, VelocityPanel.this.getHeight(), this.x1, VelocityPanel.this.getHeight() - this.y);
            graphics.drawLine(this.x1, VelocityPanel.this.getHeight() - this.y, this.x2, VelocityPanel.this.getHeight() - this.y);
            graphics.drawLine(this.x2, VelocityPanel.this.getHeight() - this.y, this.x2, VelocityPanel.this.getHeight());
        }

        void paintAsSelected(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.drawLine(this.x1, VelocityPanel.this.getHeight(), this.x1, VelocityPanel.this.getHeight() - this.y);
            graphics.drawLine(this.x1, VelocityPanel.this.getHeight() - this.y, this.x2, VelocityPanel.this.getHeight() - this.y);
            graphics.drawLine(this.x2, VelocityPanel.this.getHeight() - this.y, this.x2, VelocityPanel.this.getHeight());
            graphics.drawString(this.velocity, this.x1, VelocityPanel.this.getHeight() - this.y);
        }
    }
}

