/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.RandomDistribution;

public class ExponentialDistribution
implements RandomDistribution {
    private double rate;
    private static final long serialVersionUID = 6359607459925864639L;

    public ExponentialDistribution(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.rate = d;
    }

    public double rate() {
        return this.rate;
    }

    public double generate() {
        return -Math.log(Math.random()) / this.rate;
    }

    public double probability(double d) {
        return this.rate * Math.exp(-d * this.rate);
    }
}

