/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.MultiRandomDistribution;
import be.ac.ulg.montefiore.run.distributions.SimpleMatrix;
import java.util.Random;

public class MultiGaussianDistribution
implements MultiRandomDistribution {
    private final int dimension;
    private final double[] mean;
    private final double[][] covariance;
    private double[][] covarianceL = null;
    private double[][] covarianceInv = null;
    private double covarianceDet;
    private static final Random randomGenerator = new Random();
    private static final long serialVersionUID = -2438571303843585271L;

    public MultiGaussianDistribution(double[] dArray, double[][] dArray2) {
        if (!SimpleMatrix.isSquare(dArray2)) {
            throw new IllegalArgumentException("Covariance must be a square matrix");
        }
        this.dimension = SimpleMatrix.nbRows(dArray2);
        if (dArray.length != this.dimension) {
            throw new IllegalArgumentException("mean and covariance dimensions don't match");
        }
        this.mean = SimpleMatrix.vector(dArray);
        this.covariance = SimpleMatrix.matrix(dArray2);
    }

    public MultiGaussianDistribution(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.dimension = n;
        this.mean = SimpleMatrix.vector(n);
        this.covariance = SimpleMatrix.matrixIdentity(n);
    }

    public int dimension() {
        return this.dimension;
    }

    public double[] mean() {
        return (double[])this.mean.clone();
    }

    public double[][] covariance() {
        return SimpleMatrix.matrix(this.covariance);
    }

    private double[][] covarianceL() {
        if (this.covarianceL == null) {
            this.covarianceL = SimpleMatrix.decomposeCholesky(this.covariance);
            this.covarianceDet = SimpleMatrix.determinantCholesky(this.covarianceL);
        }
        return this.covarianceL;
    }

    private double[][] covarianceInv() {
        if (this.covarianceInv == null) {
            this.covarianceInv = SimpleMatrix.inverseCholesky(this.covarianceL());
        }
        return this.covarianceInv;
    }

    public double covarianceDet() {
        this.covarianceL();
        return this.covarianceDet;
    }

    public double[] generate() {
        double[] dArray = SimpleMatrix.vector(this.dimension);
        for (int i = 0; i < this.dimension; ++i) {
            dArray[i] = randomGenerator.nextGaussian();
        }
        return SimpleMatrix.plus(SimpleMatrix.times(this.covarianceL(), dArray), this.mean);
    }

    public double probability(double[] dArray) {
        if (dArray.length != this.dimension) {
            throw new IllegalArgumentException("Argument array size is not compatible with this distribution");
        }
        double[][] dArray2 = SimpleMatrix.matrix(SimpleMatrix.minus(dArray, this.mean));
        double d = SimpleMatrix.times(SimpleMatrix.transpose(dArray2), SimpleMatrix.times(this.covarianceInv(), dArray2))[0][0] * -0.5;
        return Math.exp(d) / (Math.pow(Math.PI * 2, (double)this.dimension / 2.0) * Math.pow(this.covarianceDet(), 0.5));
    }
}

