/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import java.util.Arrays;

class SimpleMatrix {
    SimpleMatrix() {
    }

    static double[][] matrix(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        return new double[n][n2];
    }

    static double[][] matrix(int n) {
        return SimpleMatrix.matrix(n, n);
    }

    static double[][] matrix(int n, double d) {
        return SimpleMatrix.matrix(n, n, d);
    }

    static double[][] matrix(int n, int n2, double d) {
        double[][] dArray = SimpleMatrix.matrix(n, n2);
        while (n > 0) {
            Arrays.fill(dArray[--n], d);
        }
        return dArray;
    }

    static double[][] matrix(double[][] dArray) {
        double[][] dArray2 = SimpleMatrix.matrix(SimpleMatrix.nbRows(dArray), SimpleMatrix.nbColumns(dArray));
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            for (int j = 0; j < SimpleMatrix.nbColumns(dArray); ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    static double[][] matrix(double[] dArray) {
        double[][] dArray2 = SimpleMatrix.matrix(SimpleMatrix.dimension(dArray), 1);
        for (int i = 0; i < SimpleMatrix.dimension(dArray); ++i) {
            dArray2[i][0] = dArray[i];
        }
        return dArray2;
    }

    static double[] vector(int n) {
        return new double[n];
    }

    static double[] vector(double[] dArray) {
        double[] dArray2 = (double[])dArray.clone();
        return dArray2;
    }

    static double[][] matrixIdentity(int n) {
        double[][] dArray = SimpleMatrix.matrix(n, n);
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    static int nbRows(double[][] dArray) {
        return dArray.length;
    }

    static int nbColumns(double[][] dArray) {
        return dArray[0].length;
    }

    static int dimension(double[] dArray) {
        return dArray.length;
    }

    static boolean isSquare(double[][] dArray) {
        return SimpleMatrix.nbRows(dArray) == SimpleMatrix.nbColumns(dArray);
    }

    static double[][] transpose(double[][] dArray) {
        double[][] dArray2 = SimpleMatrix.matrix(SimpleMatrix.nbColumns(dArray), SimpleMatrix.nbRows(dArray));
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            for (int j = 0; j < SimpleMatrix.nbColumns(dArray); ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    static double[][] plus(double[][] dArray, double[][] dArray2) {
        if (SimpleMatrix.nbRows(dArray) != SimpleMatrix.nbRows(dArray2) || SimpleMatrix.nbColumns(dArray) != SimpleMatrix.nbColumns(dArray2)) {
            throw new IllegalArgumentException("Incompatible sizes");
        }
        double[][] dArray3 = SimpleMatrix.matrix(dArray);
        for (int i = 0; i < SimpleMatrix.nbRows(dArray3); ++i) {
            for (int j = 0; j < SimpleMatrix.nbColumns(dArray3); ++j) {
                double[] dArray4 = dArray3[i];
                int n = j;
                dArray4[n] = dArray4[n] + dArray2[i][j];
            }
        }
        return dArray3;
    }

    static double[] plus(double[] dArray, double[] dArray2) {
        if (SimpleMatrix.dimension(dArray) != SimpleMatrix.dimension(dArray2)) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
        double[] dArray3 = SimpleMatrix.vector(dArray);
        for (int i = 0; i < SimpleMatrix.dimension(dArray); ++i) {
            int n = i;
            dArray3[n] = dArray3[n] + dArray2[i];
        }
        return dArray3;
    }

    static double[] minus(double[] dArray, double[] dArray2) {
        if (SimpleMatrix.dimension(dArray) != SimpleMatrix.dimension(dArray2)) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
        double[] dArray3 = SimpleMatrix.vector(dArray);
        for (int i = 0; i < SimpleMatrix.dimension(dArray); ++i) {
            int n = i;
            dArray3[n] = dArray3[n] - dArray2[i];
        }
        return dArray3;
    }

    static double[][] times(double[][] dArray, double[][] dArray2) {
        if (SimpleMatrix.nbRows(dArray2) != SimpleMatrix.nbColumns(dArray)) {
            throw new IllegalArgumentException("Incompatible sizes");
        }
        double[][] dArray3 = SimpleMatrix.matrix(SimpleMatrix.nbRows(dArray), SimpleMatrix.nbRows(dArray2));
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            for (int j = 0; j < SimpleMatrix.nbColumns(dArray2); ++j) {
                for (int k = 0; k < SimpleMatrix.nbColumns(dArray); ++k) {
                    double[] dArray4 = dArray3[i];
                    int n = j;
                    dArray4[n] = dArray4[n] + dArray[i][k] * dArray2[k][j];
                }
            }
        }
        return dArray3;
    }

    static double[] times(double[][] dArray, double[] dArray2) {
        if (SimpleMatrix.dimension(dArray2) != SimpleMatrix.nbColumns(dArray)) {
            throw new IllegalArgumentException("Incompatible sizes");
        }
        double[] dArray3 = SimpleMatrix.vector(SimpleMatrix.nbRows(dArray));
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            for (int j = 0; j < SimpleMatrix.nbColumns(dArray); ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    static double[][] decomposeCholesky(double[][] dArray) {
        if (!SimpleMatrix.isSquare(dArray)) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double[][] dArray2 = SimpleMatrix.matrix(SimpleMatrix.nbRows(dArray), SimpleMatrix.nbColumns(dArray));
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            double d;
            int n;
            double[] dArray3 = dArray2[i];
            double d2 = 0.0;
            for (n = 0; n < i; ++n) {
                double[] dArray4 = dArray2[n];
                double d3 = 0.0;
                for (int j = 0; j < n; ++j) {
                    d3 += dArray4[j] * dArray3[j];
                }
                dArray3[n] = d3 = (dArray[i][n] - d3) / dArray2[n][n];
                d2 += d3 * d3;
            }
            d2 = dArray[i][i] - d2;
            if (d <= 0.0) {
                throw new IllegalArgumentException("Matrix is not positive defined");
            }
            dArray2[i][i] = Math.sqrt(d2);
            for (n = i + 1; n < SimpleMatrix.nbRows(dArray); ++n) {
                dArray2[i][n] = 0.0;
            }
        }
        return dArray2;
    }

    static double determinantCholesky(double[][] dArray) {
        if (!SimpleMatrix.isSquare(dArray)) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double d = 1.0;
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            d *= dArray[i][i];
        }
        return d * d;
    }

    static double[][] inverseCholesky(double[][] dArray) {
        if (!SimpleMatrix.isSquare(dArray)) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double[][] dArray2 = SimpleMatrix.lowerTriangularInverse(dArray);
        double[][] dArray3 = SimpleMatrix.matrix(SimpleMatrix.nbRows(dArray));
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            for (int j = 0; j < SimpleMatrix.nbRows(dArray); ++j) {
                for (int k = 0; k < SimpleMatrix.nbRows(dArray); ++k) {
                    double[] dArray4 = dArray3[i];
                    int n = j;
                    dArray4[n] = dArray4[n] + dArray2[k][i] * dArray2[k][j];
                }
            }
        }
        return dArray3;
    }

    static double[][] lowerTriangularInverse(double[][] dArray) {
        if (!SimpleMatrix.isSquare(dArray)) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        double[][] dArray2 = SimpleMatrix.matrix(SimpleMatrix.nbRows(dArray));
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            if (dArray[i][i] == 0.0) {
                throw new IllegalArgumentException("Matrix is not full rank");
            }
            dArray2[i][i] = 1.0 / dArray[i][i];
            for (int j = i + 1; j < SimpleMatrix.nbRows(dArray); ++j) {
                double d = 0.0;
                for (int k = i; k < j; ++k) {
                    d -= dArray[j][k] * dArray2[k][i];
                }
                dArray2[j][i] = d / dArray[j][j];
            }
        }
        return dArray2;
    }

    static String toString(double[][] dArray) {
        String string = "[";
        for (int i = 0; i < SimpleMatrix.nbRows(dArray); ++i) {
            string = string + "[";
            for (int j = 0; j < SimpleMatrix.nbColumns(dArray); ++j) {
                string = string + " " + dArray[i][j];
            }
            string = string + " ]\n";
        }
        return string + " ]\n";
    }

    static String toString(double[] dArray) {
        String string = "[";
        for (int i = 0; i < SimpleMatrix.dimension(dArray); ++i) {
            string = string + " " + dArray[i];
        }
        return string + " ]\n";
    }
}

