/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Centroid;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentroidObservationVector
implements Centroid<ObservationVector> {
    private ObservationVector value;

    public CentroidObservationVector(ObservationVector observationVector) {
        this.value = observationVector.clone();
    }

    @Override
    public void reevaluateAdd(ObservationVector observationVector, List<? extends ObservationVector> list) {
        double[] dArray = observationVector.value;
        for (int i = 0; i < this.value.dimension(); ++i) {
            this.value.value[i] = (this.value.value[i] * (double)list.size() + dArray[i]) / (double)(list.size() + 1);
        }
    }

    @Override
    public void reevaluateRemove(ObservationVector observationVector, List<? extends ObservationVector> list) {
        double[] dArray = observationVector.value;
        for (int i = 0; i < this.value.dimension(); ++i) {
            this.value.value[i] = (this.value.value[i] * (double)list.size() - dArray[i]) / (double)(list.size() - 1);
        }
    }

    @Override
    public double distance(ObservationVector observationVector) {
        ObservationVector observationVector2 = this.value.minus(observationVector);
        double d = 0.0;
        for (int i = 0; i < observationVector2.dimension(); ++i) {
            d += observationVector2.value[i] * observationVector2.value[i];
        }
        return Math.sqrt(d);
    }
}

