/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfFactory;
import be.ac.ulg.montefiore.run.jahmm.ViterbiCalculator;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleMatrix;
import jp.crestmuse.cmx.math.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hmm<O extends Observation>
implements Serializable,
Cloneable {
    private String[] labels = null;
    private double[] pi;
    private DoubleMatrix a;
    private ArrayList<Opdf<O>> opdfs;
    private static final long serialVersionUID = 2L;

    public Hmm(int n, OpdfFactory<? extends Opdf<O>> opdfFactory) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of states must be strictly positive");
        }
        this.labels = new String[n];
        this.pi = new double[n];
        this.a = Utils.createDoubleMatrix(n, n);
        this.opdfs = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.pi[i] = 1.0 / (double)n;
            this.opdfs.add(opdfFactory.factor());
            for (int j = 0; j < n; ++j) {
                this.a.set(i, j, 1.0 / (double)n);
            }
        }
    }

    public Hmm(double[] dArray, double[][] dArray2, List<? extends Opdf<O>> list) {
        this(dArray, dArray2, list, new String[dArray.length]);
    }

    public Hmm(double[] dArray, double[][] dArray2, List<? extends Opdf<O>> list, String[] stringArray) {
        if (dArray2.length == 0 || dArray.length != dArray2.length || list.size() != dArray2.length) {
            throw new IllegalArgumentException("Wrong parameter");
        }
        this.labels = stringArray;
        double[][] dArrayArray = new double[dArray2.length][];
        for (int i = 0; i < dArray2.length; ++i) {
            if (dArray2[i].length != dArray2.length) {
                throw new IllegalArgumentException("'A' is not a squarematrix");
            }
            dArrayArray[i] = (double[])dArray2[i].clone();
        }
        this.a = Utils.createDoubleMatrix(dArrayArray);
        this.opdfs = new ArrayList<Opdf<O>>(list);
    }

    public Hmm(DoubleArray doubleArray, DoubleMatrix doubleMatrix, List<? extends Opdf<O>> list, String[] stringArray) {
        if (doubleMatrix.nrows() == 0 || doubleArray.length() != doubleMatrix.nrows() || list.size() != doubleMatrix.nrows()) {
            throw new IllegalArgumentException("Wrong parameter");
        }
        this.labels = stringArray;
        this.pi = doubleArray.toArray();
        this.a = doubleMatrix;
        this.opdfs = new ArrayList<Opdf<O>>(list);
    }

    protected Hmm(int n) {
        this(n, false);
    }

    protected Hmm(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of states must be positive");
        }
        this.labels = new String[n];
        this.pi = new double[n];
        this.a = bl ? Utils.createSparseDoubleMatrix(n, n) : Utils.createDoubleMatrix(n, n);
        this.opdfs = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.opdfs.add(null);
        }
    }

    public int nbStates() {
        return this.pi.length;
    }

    public String getLabel(int n) {
        return this.labels == null ? null : this.labels[n];
    }

    public void setLabel(int n, String string) {
        this.labels[n] = string;
    }

    public double getPi(int n) {
        return this.pi[n];
    }

    public void setPi(int n, double d) {
        this.pi[n] = d;
    }

    public Opdf<O> getOpdf(int n) {
        return this.opdfs.get(n);
    }

    public void setOpdf(int n, Opdf<O> opdf) {
        this.opdfs.set(n, opdf);
    }

    public double getAij(int n, int n2) {
        return this.a.get(n, n2);
    }

    public void setAij(int n, int n2, double d) {
        this.a.set(n, n2, d);
    }

    public int[] mostLikelyStateSequence(List<? extends O> list) {
        return new ViterbiCalculator(list, this).stateSequence();
    }

    public double probability(List<? extends O> list) {
        return new ForwardBackwardCalculator(list, this).probability();
    }

    public double lnProbability(List<? extends O> list) {
        return new ForwardBackwardScaledCalculator(list, this).lnProbability();
    }

    public double probability(List<? extends O> list, int[] nArray) {
        if (list.size() != nArray.length || list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double d = this.getPi(nArray[0]);
        Iterator<O> iterator = list.iterator();
        for (int i = 0; i < nArray.length - 1; ++i) {
            d *= this.getOpdf(nArray[i]).probability((Observation)iterator.next()) * this.getAij(nArray[i], nArray[i + 1]);
        }
        return d * this.getOpdf(nArray[nArray.length - 1]).probability((Observation)list.get(nArray.length - 1));
    }

    public String toString(NumberFormat numberFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HMM with " + this.nbStates() + " state(s)\n");
        for (int i = 0; i < this.nbStates(); ++i) {
            stringBuilder.append("\nState " + i + "\n");
            stringBuilder.append("  Label: " + (this.labels != null ? this.getLabel(i) : "") + "\n");
            stringBuilder.append("  Pi: " + this.getPi(i) + "\n");
            stringBuilder.append("  Aij:");
            for (int j = 0; j < this.nbStates(); ++j) {
                stringBuilder.append(" " + numberFormat.format(this.getAij(i, j)));
            }
            stringBuilder.append("\n");
            Opdf<O> opdf = this.getOpdf(i);
            stringBuilder.append("  Opdf: " + (opdf == null ? "null" : opdf.toString(numberFormat)) + "\n");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    public Hmm<O> clone() throws CloneNotSupportedException {
        Hmm<O> hmm = new Hmm<O>(this.nbStates());
        hmm.pi = (double[])this.pi.clone();
        hmm.a = this.a.clone();
        for (int i = 0; i < hmm.opdfs.size(); ++i) {
            hmm.opdfs.set(i, this.opdfs.get(i).clone());
        }
        return hmm;
    }
}

