/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Centroid;
import be.ac.ulg.montefiore.run.jahmm.CentroidFactory;
import be.ac.ulg.montefiore.run.jahmm.CentroidObservationVector;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservationVector
extends Observation
implements Cloneable,
CentroidFactory<ObservationVector> {
    final double[] value;

    public ObservationVector(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Dimension must be strictly positive");
        }
        this.value = new double[n];
    }

    public ObservationVector(double[] dArray) {
        this(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            this.value[i] = dArray[i];
        }
    }

    public int dimension() {
        return this.value.length;
    }

    public double[] values() {
        return (double[])this.value.clone();
    }

    public double value(int n) {
        return this.value[n];
    }

    @Override
    public Centroid<ObservationVector> factor() {
        return new CentroidObservationVector(this);
    }

    public ObservationVector plus(ObservationVector observationVector) {
        if (this.dimension() != observationVector.dimension()) {
            throw new IllegalArgumentException();
        }
        ObservationVector observationVector2 = new ObservationVector(this.dimension());
        for (int i = 0; i < this.dimension(); ++i) {
            observationVector2.value[i] = this.value[i] + observationVector.value[i];
        }
        return observationVector2;
    }

    public ObservationVector times(double d) {
        ObservationVector observationVector = this.clone();
        int n = 0;
        while (n < this.dimension()) {
            int n2 = n++;
            observationVector.value[n2] = observationVector.value[n2] * d;
        }
        return observationVector;
    }

    public ObservationVector minus(ObservationVector observationVector) {
        if (this.dimension() != observationVector.dimension()) {
            throw new IllegalArgumentException();
        }
        ObservationVector observationVector2 = new ObservationVector(this.dimension());
        for (int i = 0; i < this.dimension(); ++i) {
            observationVector2.value[i] = this.value[i] - observationVector.value[i];
        }
        return observationVector2;
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String string = "[";
        for (int i = 0; i < this.value.length; ++i) {
            string = string + " " + numberFormat.format(this.value[i]);
        }
        return string + " ]";
    }

    public ObservationVector clone() {
        return new ObservationVector(this.value);
    }
}

