/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationReal;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfGaussian
implements Opdf<ObservationReal> {
    private GaussianDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfGaussian() {
        this.distribution = new GaussianDistribution();
    }

    public OpdfGaussian(double d, double d2) {
        this.distribution = new GaussianDistribution(d, d2);
    }

    public double mean() {
        return this.distribution.mean();
    }

    public double variance() {
        return this.distribution.variance();
    }

    @Override
    public double probability(ObservationReal observationReal) {
        return this.distribution.probability(observationReal.value);
    }

    @Override
    public ObservationReal generate() {
        return new ObservationReal(this.distribution.generate());
    }

    public void fit(ObservationReal ... observationRealArray) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(observationRealArray));
    }

    @Override
    public void fit(Collection<? extends ObservationReal> collection) {
        double[] dArray = new double[collection.size()];
        Arrays.fill(dArray, 1.0 / (double)collection.size());
        this.fit(collection, dArray);
    }

    public void fit(ObservationReal[] observationRealArray, double[] dArray) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(observationRealArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationReal> collection, double[] dArray) {
        if (collection.isEmpty() || collection.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        int n = 0;
        for (ObservationReal observationReal : collection) {
            d += observationReal.value * dArray[n++];
        }
        double d2 = 0.0;
        n = 0;
        for (ObservationReal observationReal : collection) {
            double d3 = observationReal.value - d;
            d2 += d3 * d3 * dArray[n++];
        }
        this.distribution = new GaussianDistribution(d, d2);
    }

    public OpdfGaussian clone() {
        try {
            return (OpdfGaussian)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        return "Gaussian distribution --- Mean: " + numberFormat.format(this.distribution.mean()) + " Variance " + numberFormat.format(this.distribution.variance());
    }
}

