/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.distributions.GaussianMixtureDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationReal;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfGaussianMixture
implements Opdf<ObservationReal> {
    private GaussianMixtureDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfGaussianMixture(int n) {
        this.distribution = new GaussianMixtureDistribution(n);
    }

    public OpdfGaussianMixture(double[] dArray, double[] dArray2, double[] dArray3) {
        this.distribution = new GaussianMixtureDistribution(dArray, dArray2, dArray3);
    }

    @Override
    public double probability(ObservationReal observationReal) {
        return this.distribution.probability(observationReal.value);
    }

    @Override
    public ObservationReal generate() {
        return new ObservationReal(this.distribution.generate());
    }

    public int nbGaussians() {
        return this.distribution.nbGaussians();
    }

    public double[] proportions() {
        return this.distribution.proportions();
    }

    public double[] means() {
        double[] dArray = new double[this.nbGaussians()];
        GaussianDistribution[] gaussianDistributionArray = this.distribution.distributions();
        for (int i = 0; i < gaussianDistributionArray.length; ++i) {
            dArray[i] = gaussianDistributionArray[i].mean();
        }
        return dArray;
    }

    public double[] variances() {
        double[] dArray = new double[this.nbGaussians()];
        GaussianDistribution[] gaussianDistributionArray = this.distribution.distributions();
        for (int i = 0; i < gaussianDistributionArray.length; ++i) {
            dArray[i] = gaussianDistributionArray[i].variance();
        }
        return dArray;
    }

    public void fit(ObservationReal ... observationRealArray) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(observationRealArray));
    }

    @Override
    public void fit(Collection<? extends ObservationReal> collection) {
        double[] dArray = new double[collection.size()];
        Arrays.fill(dArray, 1.0 / (double)collection.size());
        this.fit(collection, dArray);
    }

    public void fit(ObservationReal[] observationRealArray, double[] dArray) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(observationRealArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationReal> collection, double[] dArray) {
        if (collection.isEmpty() || collection.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        ObservationReal[] observationRealArray = collection.toArray(new ObservationReal[collection.size()]);
        double[][] dArray2 = this.getDelta(observationRealArray);
        double[] dArray3 = this.computeNewMixingProportions(dArray2, observationRealArray, dArray);
        double[] dArray4 = this.computeNewMeans(dArray2, observationRealArray, dArray);
        double[] dArray5 = this.computeNewVariances(dArray2, observationRealArray, dArray);
        this.distribution = new GaussianMixtureDistribution(dArray4, dArray5, dArray3);
    }

    private double[][] getDelta(ObservationReal[] observationRealArray) {
        double[][] dArray = new double[this.distribution.nbGaussians()][observationRealArray.length];
        for (int i = 0; i < this.distribution.nbGaussians(); ++i) {
            double[] dArray2 = this.distribution.proportions();
            GaussianDistribution[] gaussianDistributionArray = this.distribution.distributions();
            for (int j = 0; j < observationRealArray.length; ++j) {
                dArray[i][j] = dArray2[i] * gaussianDistributionArray[i].probability(observationRealArray[j].value) / this.probability(observationRealArray[j]);
            }
        }
        return dArray;
    }

    private double[] computeNewMixingProportions(double[][] dArray, ObservationReal[] observationRealArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[this.distribution.nbGaussians()];
        double d = 0.0;
        Arrays.fill(dArray3, 0.0);
        for (int i = 0; i < this.distribution.nbGaussians(); ++i) {
            for (n = 0; n < dArray2.length; ++n) {
                int n2 = i;
                dArray3[n2] = dArray3[n2] + dArray2[n] * dArray[i][n];
                d += dArray2[n] * dArray[i][n];
            }
        }
        double[] dArray4 = new double[this.distribution.nbGaussians()];
        for (n = 0; n < this.distribution.nbGaussians(); ++n) {
            dArray4[n] = dArray3[n] / d;
        }
        return dArray4;
    }

    private double[] computeNewMeans(double[][] dArray, ObservationReal[] observationRealArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[this.distribution.nbGaussians()];
        double[] dArray4 = new double[this.distribution.nbGaussians()];
        Arrays.fill(dArray3, 0.0);
        Arrays.fill(dArray4, 0.0);
        for (int i = 0; i < this.distribution.nbGaussians(); ++i) {
            for (n = 0; n < observationRealArray.length; ++n) {
                int n2 = i;
                dArray3[n2] = dArray3[n2] + dArray2[n] * dArray[i][n] * observationRealArray[n].value;
                int n3 = i;
                dArray4[n3] = dArray4[n3] + dArray2[n] * dArray[i][n];
            }
        }
        double[] dArray5 = new double[this.distribution.nbGaussians()];
        for (n = 0; n < this.distribution.nbGaussians(); ++n) {
            dArray5[n] = dArray3[n] / dArray4[n];
        }
        return dArray5;
    }

    private double[] computeNewVariances(double[][] dArray, ObservationReal[] observationRealArray, double[] dArray2) {
        double[] dArray3 = new double[this.distribution.nbGaussians()];
        double[] dArray4 = new double[this.distribution.nbGaussians()];
        Arrays.fill(dArray3, 0.0);
        Arrays.fill(dArray4, 0.0);
        for (int i = 0; i < this.distribution.nbGaussians(); ++i) {
            GaussianDistribution[] gaussianDistributionArray = this.distribution.distributions();
            for (int j = 0; j < observationRealArray.length; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray2[j] * dArray[i][j] * (observationRealArray[j].value - gaussianDistributionArray[i].mean()) * (observationRealArray[j].value - gaussianDistributionArray[i].mean());
                int n2 = i;
                dArray4[n2] = dArray4[n2] + dArray2[j] * dArray[i][j];
            }
        }
        double[] dArray5 = new double[this.distribution.nbGaussians()];
        for (int i = 0; i < this.distribution.nbGaussians(); ++i) {
            dArray5[i] = dArray3[i] / dArray4[i];
        }
        return dArray5;
    }

    public OpdfGaussianMixture clone() {
        try {
            return (OpdfGaussianMixture)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String string = "Gaussian mixture distribution --- ";
        double[] dArray = this.proportions();
        double[] dArray2 = this.means();
        double[] dArray3 = this.variances();
        for (int i = 0; i < this.distribution.nbGaussians(); ++i) {
            string = string + "Gaussian " + (i + 1) + ":\n";
            string = string + "\tMixing Prop = " + numberFormat.format(dArray[i]) + "\n";
            string = string + "\tMean = " + numberFormat.format(dArray2[i]) + "\n";
            string = string + "\tVariance = " + numberFormat.format(dArray3[i]) + "\n";
        }
        return string;
    }
}

