/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.RelatedObjs;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.Types;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmReader;
import be.ac.ulg.montefiore.run.jahmm.io.HmmWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchScaledLearner;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BWActionHandler
extends ActionHandler {
    BWActionHandler() {
    }

    @Override
    public void act() throws IOException, FileFormatException, AbnormalTerminationException {
        EnumSet<CommandLineArguments.Arguments> enumSet = EnumSet.of(CommandLineArguments.Arguments.OPDF, CommandLineArguments.Arguments.OUT_HMM, CommandLineArguments.Arguments.IN_HMM, CommandLineArguments.Arguments.IN_SEQ, CommandLineArguments.Arguments.NB_ITERATIONS);
        CommandLineArguments.checkArgs(enumSet);
        int n = CommandLineArguments.Arguments.NB_ITERATIONS.getAsInt();
        OutputStream outputStream = CommandLineArguments.Arguments.OUT_HMM.getAsOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        InputStream inputStream = CommandLineArguments.Arguments.IN_HMM.getAsInputStream();
        InputStream inputStream2 = CommandLineArguments.Arguments.IN_SEQ.getAsInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
        InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream2, "ISO-8859-1");
        this.learn(Types.relatedObjs(), inputStreamReader, inputStreamReader2, outputStreamWriter, n);
        ((Writer)outputStreamWriter).flush();
    }

    private <O extends Observation> void learn(RelatedObjs<O> relatedObjs, Reader reader, Reader reader2, Writer writer, int n) throws IOException, FileFormatException {
        List<List<O>> list = relatedObjs.readSequences(reader2);
        OpdfReader<Opdf<O>> opdfReader = relatedObjs.opdfReader();
        OpdfWriter<Opdf<O>> opdfWriter = relatedObjs.opdfWriter();
        Hmm<O> hmm = HmmReader.read(reader, opdfReader);
        BaumWelchScaledLearner baumWelchScaledLearner = new BaumWelchScaledLearner();
        baumWelchScaledLearner.setNbIterations(n);
        Hmm<O> hmm2 = baumWelchScaledLearner.learn(hmm, list);
        HmmWriter.write(writer, opdfWriter, hmm2);
    }
}

