/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.WrongArgumentsException;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Cli {
    public static final String CHARSET = "ISO-8859-1";

    public static void main(String ... stringArray) throws IOException {
        try {
            System.exit(Cli.run(stringArray));
        }
        catch (AbnormalTerminationException abnormalTerminationException) {
            System.err.println(abnormalTerminationException);
            System.exit(-1);
        }
    }

    public static int run(String ... stringArray) throws IOException, AbnormalTerminationException {
        CommandLineArguments.reset();
        ActionHandler.Actions actions = CommandLineArguments.parseAction(stringArray);
        if (actions == null) {
            throw new WrongArgumentsException("Valid action required");
        }
        ActionHandler actionHandler = null;
        try {
            actionHandler = actions.handler().newInstance();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        actionHandler.parseArguments(stringArray);
        try {
            actionHandler.act();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
            return -1;
        }
        catch (FileFormatException fileFormatException) {
            System.err.println(fileFormatException);
            return -1;
        }
        return 0;
    }
}

