/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.WrongArgumentsException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandLineArguments {
    CommandLineArguments() {
    }

    static void parse(String[] stringArray) throws WrongArgumentsException {
        block0: for (int i = 1; i < stringArray.length; ++i) {
            for (Arguments arguments : Arguments.values()) {
                if (!arguments.argString.equals(stringArray[i])) continue;
                if (arguments.getIsSet()) {
                    throw new WrongArgumentsException("Argument '" + stringArray[i] + "' given twice");
                }
                arguments.setIsSet(true);
                if (!arguments.hasAllowedValues()) continue block0;
                if (i == stringArray.length - 1) {
                    throw new WrongArgumentsException("Argument '" + stringArray[i] + "' calls for an option");
                }
                String string = stringArray[++i];
                if (!arguments.allowedValues[0].equals("") && !Arrays.asList(arguments.allowedValues).contains(string)) {
                    throw new WrongArgumentsException("Invalid option '" + string + "'");
                }
                arguments.set(string);
                continue block0;
            }
            throw new WrongArgumentsException("Unknown argument '" + stringArray[i] + "'");
        }
    }

    static void checkArgs(EnumSet<Arguments> enumSet) throws WrongArgumentsException {
        if (enumSet.contains((Object)Arguments.OPDF)) {
            String string = Arguments.OPDF.get();
            if (string.equals("integer")) {
                enumSet.add(Arguments.INTEGER_RANGE);
            } else if (string.equals("multi_gaussian")) {
                enumSet.add(Arguments.VECTOR_DIMENSION);
            } else if (!string.equals("gaussian")) {
                if (string.equals("gaussian_mixture")) {
                    enumSet.add(Arguments.NB_GAUSSIANS);
                } else {
                    new AssertionError((Object)("Unknown observation type '" + string + "'"));
                }
            }
        }
        for (Arguments arguments : enumSet) {
            if (arguments.getIsSet() || arguments.hasDefaultValue()) continue;
            throw new WrongArgumentsException("Argument '" + arguments.argString + "' expected");
        }
        for (Arguments arguments : EnumSet.complementOf(enumSet)) {
            if (!arguments.getIsSet()) continue;
            throw new WrongArgumentsException("Argument '" + arguments.argString + "' not expected");
        }
    }

    static ActionHandler.Actions parseAction(String[] stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        ActionHandler.Actions actions = null;
        for (ActionHandler.Actions actions2 : ActionHandler.Actions.values()) {
            if (!actions2.toString().equals(stringArray[0])) continue;
            actions = actions2;
        }
        return actions;
    }

    static void reset() {
        for (Arguments arguments : Arguments.values()) {
            arguments.setIsSet(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Arguments {
        IN_HMM("-i", "-"),
        IN_KL_HMM("-ikl", ""),
        OUT_HMM("-o", "-"),
        IN_SEQ("-is", ""),
        OUT_SEQS("-os", "-"),
        OPDF("-opdf", "integer", "gaussian", "gaussian_mixture", "multi_gaussian"),
        INTEGER_RANGE("-r", ""),
        NB_GAUSSIANS("-ng", ""),
        VECTOR_DIMENSION("-d", ""),
        NB_ITERATIONS("-ni", "10"),
        NB_STATES("-n", "");

        final String argString;
        final String[] allowedValues;
        private String value;
        private String defaultValue;
        private boolean isSet = false;

        private Arguments(String string2, String ... stringArray) {
            this.argString = string2;
            if (stringArray.length == 1 && !stringArray[0].equals("")) {
                this.defaultValue = stringArray[0];
                this.allowedValues = new String[]{""};
            } else {
                this.defaultValue = null;
                this.allowedValues = stringArray;
            }
        }

        boolean hasAllowedValues() {
            return this.allowedValues.length != 0;
        }

        void set(String string) {
            this.value = string;
        }

        boolean getIsSet() {
            return this.isSet;
        }

        void setIsSet(boolean bl) {
            this.isSet = bl;
        }

        boolean hasDefaultValue() {
            return this.defaultValue != null;
        }

        String get() throws WrongArgumentsException {
            if (!this.isSet) {
                if (this.hasDefaultValue()) {
                    return this.defaultValue;
                }
                throw new WrongArgumentsException("Argument '" + this.argString + "' expected");
            }
            return this.value;
        }

        String getDefault() {
            if (!this.hasDefaultValue()) {
                throw new UnsupportedOperationException("No default value");
            }
            return this.defaultValue;
        }

        int getAsInt() throws WrongArgumentsException {
            int n = -1;
            try {
                n = Integer.parseInt(this.get());
            }
            catch (NumberFormatException numberFormatException) {
                throw new WrongArgumentsException("'" + this.get() + "' is not a number; number expected");
            }
            return n;
        }

        InputStream getAsInputStream() throws FileNotFoundException, WrongArgumentsException {
            if (this.get().equals("-")) {
                return System.in;
            }
            return new FileInputStream(this.get());
        }

        OutputStream getAsOutputStream() throws FileNotFoundException, WrongArgumentsException {
            if (this.get().equals("-")) {
                return System.out;
            }
            return new FileOutputStream(this.get());
        }
    }
}

