/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.RelatedObjs;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.Types;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmReader;
import be.ac.ulg.montefiore.run.jahmm.toolbox.KullbackLeiblerDistanceCalculator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KLActionHandler
extends ActionHandler {
    @Override
    public void act() throws FileNotFoundException, IOException, FileFormatException, AbnormalTerminationException {
        EnumSet<CommandLineArguments.Arguments> enumSet = EnumSet.of(CommandLineArguments.Arguments.OPDF, CommandLineArguments.Arguments.IN_HMM, CommandLineArguments.Arguments.IN_KL_HMM);
        CommandLineArguments.checkArgs(enumSet);
        InputStream inputStream = CommandLineArguments.Arguments.IN_KL_HMM.getAsInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        inputStream = CommandLineArguments.Arguments.IN_HMM.getAsInputStream();
        InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream);
        this.distance(Types.relatedObjs(), inputStreamReader, inputStreamReader2);
    }

    private <O extends Observation> void distance(RelatedObjs<O> relatedObjs, Reader reader, Reader reader2) throws IOException, FileFormatException {
        Hmm<O> hmm = HmmReader.read(reader, relatedObjs.opdfReader());
        Hmm<O> hmm2 = HmmReader.read(reader2, relatedObjs.opdfReader());
        KullbackLeiblerDistanceCalculator kullbackLeiblerDistanceCalculator = new KullbackLeiblerDistanceCalculator();
        System.out.println(kullbackLeiblerDistanceCalculator.distance(hmm, hmm2));
    }
}

