/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfFactory;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.RelatedObjs;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.Types;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import be.ac.ulg.montefiore.run.jahmm.learn.KMeansLearner;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KMeansActionHandler
extends ActionHandler {
    KMeansActionHandler() {
    }

    @Override
    public void act() throws FileNotFoundException, IOException, FileFormatException, AbnormalTerminationException {
        EnumSet<CommandLineArguments.Arguments> enumSet = EnumSet.of(CommandLineArguments.Arguments.OPDF, CommandLineArguments.Arguments.NB_STATES, CommandLineArguments.Arguments.OUT_HMM, CommandLineArguments.Arguments.IN_SEQ);
        CommandLineArguments.checkArgs(enumSet);
        int n = CommandLineArguments.Arguments.NB_STATES.getAsInt();
        OutputStream outputStream = CommandLineArguments.Arguments.OUT_HMM.getAsOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        InputStream inputStream = CommandLineArguments.Arguments.IN_SEQ.getAsInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.learn(n, Types.relatedObjs(), inputStreamReader, outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }

    private <O extends Observation> void learn(int n, RelatedObjs<O> relatedObjs, Reader reader, Writer writer) throws IOException, FileFormatException {
        OpdfFactory<Opdf<O>> opdfFactory = relatedObjs.opdfFactory();
        List<List<O>> list = relatedObjs.readSequences(reader);
        OpdfWriter<Opdf<O>> opdfWriter = relatedObjs.opdfWriter();
        KMeansLearner<O> kMeansLearner = new KMeansLearner<O>(n, opdfFactory, list);
        Hmm<O> hmm = kMeansLearner.learn();
        HmmWriter.write(writer, opdfWriter, hmm);
    }
}

