/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.OpdfInteger;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import java.io.IOException;
import java.io.StreamTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfIntegerReader
extends OpdfReader<OpdfInteger> {
    private final int nbEntries;

    @Override
    String keyword() {
        return "IntegerOPDF";
    }

    public OpdfIntegerReader() {
        this.nbEntries = -1;
    }

    public OpdfIntegerReader(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.nbEntries = n;
    }

    @Override
    public OpdfInteger read(StreamTokenizer streamTokenizer) throws IOException, FileFormatException {
        HmmReader.readWords(streamTokenizer, this.keyword());
        double[] dArray = OpdfReader.read(streamTokenizer, -1);
        if (this.nbEntries > 0 && dArray.length != this.nbEntries) {
            throw new FileFormatException(streamTokenizer.lineno(), "Invalid distribution (should operate over 0..." + (this.nbEntries - 1) + ")");
        }
        return new OpdfInteger(dArray);
    }
}

