/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.learn;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchLearner;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaumWelchScaledLearner
extends BaumWelchLearner {
    @Override
    protected <O extends Observation> ForwardBackwardCalculator generateForwardBackwardCalculator(List<? extends O> list, Hmm<O> hmm) {
        return new ForwardBackwardScaledCalculator(list, hmm, EnumSet.allOf(ForwardBackwardCalculator.Computation.class));
    }

    @Override
    protected <O extends Observation> double[][][] estimateXi(List<? extends O> list, ForwardBackwardCalculator forwardBackwardCalculator, Hmm<O> hmm) {
        if (list.size() <= 1) {
            throw new IllegalArgumentException("Observation sequence too short");
        }
        double[][][] dArray = new double[list.size() - 1][hmm.nbStates()][hmm.nbStates()];
        Iterator<O> iterator = list.iterator();
        iterator.next();
        for (int i = 0; i < list.size() - 1; ++i) {
            Observation observation = (Observation)iterator.next();
            for (int j = 0; j < hmm.nbStates(); ++j) {
                for (int k = 0; k < hmm.nbStates(); ++k) {
                    dArray[i][j][k] = forwardBackwardCalculator.alphaElement(i, j) * hmm.getAij(j, k) * hmm.getOpdf(k).probability(observation) * forwardBackwardCalculator.betaElement(i + 1, k);
                }
            }
        }
        return dArray;
    }
}

