/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.learn;

import be.ac.ulg.montefiore.run.jahmm.CentroidFactory;
import be.ac.ulg.montefiore.run.jahmm.KMeansCalculator;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Clusters<O extends CentroidFactory<? super O>> {
    private Hashtable<O, Value> clustersHash = new Hashtable();
    private ArrayList<Collection<O>> clusters = new ArrayList();

    public Clusters(int n, List<? extends O> list) {
        KMeansCalculator<O> kMeansCalculator = new KMeansCalculator<O>(n, list);
        for (int i = 0; i < n; ++i) {
            Collection<O> collection = kMeansCalculator.cluster(i);
            this.clusters.add(collection);
            for (CentroidFactory centroidFactory : collection) {
                this.clustersHash.put(centroidFactory, new Value(i));
            }
        }
    }

    public boolean isInCluster(Observation observation, int n) {
        return this.clusterNb(observation) == n;
    }

    public int clusterNb(Observation observation) {
        return this.clustersHash.get(observation).getClusterNb();
    }

    public Collection<O> cluster(int n) {
        return this.clusters.get(n);
    }

    public void remove(Observation observation, int n) {
        this.clustersHash.get(observation).setClusterNb(-1);
        this.clusters.get(n).remove(observation);
    }

    public void put(O o, int n) {
        this.clustersHash.get(o).setClusterNb(n);
        this.clusters.get(n).add(o);
    }

    class Value {
        private int clusterNb;

        Value(int n) {
            this.clusterNb = n;
        }

        void setClusterNb(int n) {
            this.clusterNb = n;
        }

        int getClusterNb() {
            return this.clusterNb;
        }
    }
}

