/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.toolbox;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KullbackLeiblerDistanceCalculator {
    private int sequencesLength = 1000;
    private int nbSequences = 10;

    public <O extends Observation> double distance(Hmm<O> hmm, Hmm<? super O> hmm2) {
        double d = 0.0;
        for (int i = 0; i < this.nbSequences; ++i) {
            List<O> list = new MarkovGenerator<O>(hmm).observationSequence(this.sequencesLength);
            d += (new ForwardBackwardScaledCalculator(list, hmm).lnProbability() - new ForwardBackwardScaledCalculator(list, hmm2).lnProbability()) / (double)this.sequencesLength;
        }
        return d / (double)this.nbSequences;
    }

    public int getNbSequences() {
        return this.nbSequences;
    }

    public void setNbSequences(int n) {
        this.nbSequences = n;
    }

    public int getSequencesLength() {
        return this.sequencesLength;
    }

    public void setSequencesLength(int n) {
        this.sequencesLength = n;
    }
}

