/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDecoder;
import jp.crestmuse.cmx.amusaj.filewrappers.AttrIterator;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.filewrappers.AbstractHeaderNodeInterface;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.misc.QueueReader;
import jp.crestmuse.cmx.misc.QueueWrapper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmusaXMLWrapper
extends CMXFileWrapper
implements AmusaDataSetCompatible<TimeSeriesCompatible> {
    private Header header = null;
    private List<TimeSeriesCompatible> datalist = null;
    private String format = null;
    public static final String TOP_TAG = "amusaxml";
    private static final String HEADER_TAG = "header";
    private static final String DATA_TAG = "data";
    private AmusaDecoder decoder = AmusaDecoder.getInstance();

    public void changeDecoder(AmusaDecoder amusaDecoder) {
        this.decoder = amusaDecoder;
    }

    @Override
    protected void analyze() {
        NamedNodeMap namedNodeMap = this.getDocument().getDocumentElement().getAttributes();
        this.format = namedNodeMap.getNamedItem("format").getNodeValue();
        this.header = new Header(this.selectSingleNode("/amusaxml/header"));
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public String getHeader(String string, String string2) {
        return this.header.getHeaderElement(string + ":" + string2);
    }

    @Override
    public int getHeaderInt(String string, String string2) {
        return Integer.parseInt(this.getHeader(string, string2));
    }

    @Override
    public double getHeaderDouble(String string, String string2) {
        return Double.parseDouble(this.getHeader(string, string2));
    }

    @Override
    public boolean containsHeaderKey(String string, String string2) {
        return this.header.containsHeaderKey(string + ":" + string2);
    }

    @Override
    public void setHeader(String string, String string2, String string3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHeader(String string, String string2, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHeader(String string, String string2, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(TimeSeriesCompatible timeSeriesCompatible) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TimeSeriesCompatible> getDataList() {
        if (this.datalist == null) {
            NodeList nodeList = this.selectNodeList("/amusaxml/data");
            int n = nodeList.getLength();
            this.datalist = new ArrayList<TimeSeriesCompatible>();
            for (int i = 0; i < n; ++i) {
                this.datalist.add(new Data(nodeList.item(i)));
            }
        }
        return this.datalist;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Data
    extends NodeInterface
    implements TimeSeriesCompatible {
        private int dim;
        private int nFrames;
        private int timeunit;
        private Queue queue;
        private QueueWrapper qwrap;

        protected Data(Node node) {
            super(node);
            this.dim = -1;
            this.timeunit = -1;
            if (this.hasAttribute("dim")) {
                this.dim = this.getAttributeInt("dim");
            }
            if (this.hasAttribute("timeunit")) {
                this.timeunit = this.getAttributeInt("timeunit");
            }
            this.nFrames = this.getAttributeInt("frames");
            this.queue = new LinkedList();
            this.qwrap = new QueueWrapper(this.queue);
            StringTokenizer stringTokenizer = new StringTokenizer(this.getText());
            for (int i = 0; i < this.nFrames; ++i) {
                this.queue.add(AmusaXMLWrapper.this.decoder.decode(stringTokenizer, AmusaXMLWrapper.this.format, this.dim));
            }
            this.queue.add(SPTerminator.getInstance());
        }

        @Override
        protected final String getSupportedNodeName() {
            return AmusaXMLWrapper.DATA_TAG;
        }

        public final QueueReader getQueueReader() {
            return this.qwrap.createReader();
        }

        @Override
        public final int dim() {
            return this.dim;
        }

        public final int frames() {
            return this.nFrames;
        }

        public final int timeunit() {
            return this.timeunit;
        }

        @Override
        public final boolean isComplete() {
            return true;
        }

        public final void add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setAttribute(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setAttribute(String string, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setAttribute(String string, double d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Iterator<Map.Entry<String, String>> getAttributeIterator() {
            return new AttrIterator(this.node().getAttributes());
        }
    }

    private class Header
    extends AbstractHeaderNodeInterface {
        Header(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "category";
        }
    }
}

