/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMFOverlapChecker
extends CMXCommand<MIDIXMLWrapper, MIDIXMLWrapper> {
    MIDIEventWithTime[][] last1 = new MIDIEventWithTime[128][16];
    int div;
    int nTracks = 1;

    @Override
    protected MIDIXMLWrapper readInputData(String string) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        return MIDIXMLWrapper.readSMF(string);
    }

    @Override
    protected MIDIXMLWrapper run(MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, SAXException, TransformerException, IOException {
        this.div = mIDIXMLWrapper.ticksPerBeat();
        MIDIXMLWrapper.Track[] trackArray = mIDIXMLWrapper.getTrackList();
        for (int i = 0; i < trackArray.length; ++i) {
            int n = 0;
            MIDIXMLWrapper.MIDIEvent[] mIDIEventArray = trackArray[i].getMIDIEventList();
            ArrayList arrayList = new ArrayList();
            for (MIDIXMLWrapper.MIDIEvent mIDIEvent : mIDIEventArray) {
                MIDIEventWithTime mIDIEventWithTime = new MIDIEventWithTime(mIDIEvent, n += mIDIEvent.deltaTime());
                this.checkMIDIEvent(mIDIEventWithTime);
            }
        }
        return null;
    }

    private void checkMIDIEvent(MIDIEventWithTime mIDIEventWithTime) {
        if (this.isNoteOn(mIDIEventWithTime)) {
            byte by;
            int n = mIDIEventWithTime.evt.value(0);
            MIDIEventWithTime mIDIEventWithTime2 = this.last1[n][by = mIDIEventWithTime.evt.channel()];
            if (mIDIEventWithTime2 == null) {
                this.last1[n][by] = mIDIEventWithTime;
            } else if (this.isNoteOn(mIDIEventWithTime2)) {
                System.out.printf("Overlap detected: NoteOn  (beat=%3d, tick=%3d, note=%3d, vel=%3d)\n", mIDIEventWithTime2.time / this.div, mIDIEventWithTime2.time % this.div, mIDIEventWithTime2.evt.value(0), mIDIEventWithTime2.evt.value(1));
                System.out.printf("                  NoteOn  (beat=%3d, tick=%3d, note=%3d, vel=%3d)\n", mIDIEventWithTime.time / this.div, mIDIEventWithTime.time % this.div, mIDIEventWithTime.evt.value(0), mIDIEventWithTime.evt.value(1));
                this.last1[n][by] = mIDIEventWithTime;
            } else if (this.isNoteOff(mIDIEventWithTime2)) {
                this.last1[n][by] = mIDIEventWithTime;
            }
        } else if (this.isNoteOff(mIDIEventWithTime)) {
            byte by;
            int n = mIDIEventWithTime.evt.value(0);
            MIDIEventWithTime mIDIEventWithTime3 = this.last1[n][by = mIDIEventWithTime.evt.channel()];
            if (mIDIEventWithTime3 == null) {
                this.last1[n][by] = mIDIEventWithTime;
            } else if (this.isNoteOn(mIDIEventWithTime3)) {
                this.last1[n][by] = mIDIEventWithTime;
            } else if (this.isNoteOff(mIDIEventWithTime3)) {
                System.out.printf("Overlap detected: NoteOff (beat=%3d, tick=%3d, note=%3d, vel=%3d)\n", mIDIEventWithTime3.time / this.div, mIDIEventWithTime3.time % this.div, mIDIEventWithTime3.evt.value(0), mIDIEventWithTime3.evt.value(1));
                System.out.printf("                  NoteOff (beat=%3d, tick=%3d, note=%3d, vel=%3d)\n", mIDIEventWithTime.time / this.div, mIDIEventWithTime.time % this.div, mIDIEventWithTime.evt.value(0), mIDIEventWithTime.evt.value(1));
                this.last1[n][by] = mIDIEventWithTime;
            }
        }
    }

    private boolean isNoteOn(MIDIEventWithTime mIDIEventWithTime) {
        return mIDIEventWithTime.evt.messageType().equals("NoteOn") && mIDIEventWithTime.evt.value(1) > 0;
    }

    private boolean isNoteOff(MIDIEventWithTime mIDIEventWithTime) {
        return mIDIEventWithTime.evt.messageType().equals("NoteOff") || mIDIEventWithTime.evt.messageType().equals("NoteOn") && mIDIEventWithTime.evt.value(1) == 0;
    }

    public static void main(String[] stringArray) {
        SMFOverlapChecker sMFOverlapChecker = new SMFOverlapChecker();
        try {
            sMFOverlapChecker.start(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    class MIDIEventWithTime
    implements Comparable {
        MIDIXMLWrapper.MIDIEvent evt;
        int time;

        MIDIEventWithTime(MIDIXMLWrapper.MIDIEvent mIDIEvent, int n) {
            this.evt = mIDIEvent;
            this.time = n;
        }

        public int compareTo(Object object) {
            return this.time - ((MIDIEventWithTime)object).time;
        }
    }
}

